/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol;

import fr.orpheo.models.spark.protocol.ConfigProtocol;
import fr.orpheo.models.spark.protocol.UniqueMapping;
import fr.orpheo.models.spark.protocol.v1.ConfigProtocolV1;

public class ProtocolManager {
    private static final UniqueMapping<Integer, ConfigProtocol> protocolRegistry = new UniqueMapping();
    public static int LATEST_PROTOCOL_VERSION = 0;

    public static void registerProtocol(ConfigProtocol protocol) {
        int newProtocolVersion = protocol.getVersion();
        protocolRegistry.register(newProtocolVersion, protocol);
        if (newProtocolVersion > LATEST_PROTOCOL_VERSION) {
            LATEST_PROTOCOL_VERSION = newProtocolVersion;
        }
    }

    public static ConfigProtocol getLatestProtocol() {
        return protocolRegistry.get(LATEST_PROTOCOL_VERSION);
    }

    public static ConfigProtocol getProtocolByVersion(int version) {
        return protocolRegistry.get(version);
    }

    static {
        ConfigProtocolV1.init();
    }
}

