/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.Typable;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import java.util.List;

public abstract class Group
implements Typable<GroupType> {
    private final GroupType type;
    private final AccessType accessType;
    private final List<ParamID> paramIDs;

    protected Group(GroupType type, AccessType accessType, List<ParamID> paramIDs) {
        this.type = type;
        this.accessType = accessType;
        if (paramIDs == null || paramIDs.size() == 0) {
            throw new IllegalArgumentException("The group " + this.type.getName() + " must have at least 1 ParamID");
        }
        this.paramIDs = paramIDs;
    }

    public String getName() {
        return this.type.getName();
    }

    @Override
    public GroupType getType() {
        return this.type;
    }

    public boolean isReadable() {
        return switch (this.accessType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 2 -> true;
            case 1 -> false;
        };
    }

    public boolean isWritable() {
        return switch (this.accessType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1, 2 -> true;
            case 0 -> false;
        };
    }

    public List<ParamID> getParamIDs() {
        return this.paramIDs;
    }

    public abstract String getBeautifulString(List<Integer> var1);

    public abstract List<Integer> getVerifiedRegisterValues(String var1);

    public abstract List<String> getOptions();

    protected static enum AccessType {
        READ_ONLY,
        WRITE_ONLY,
        READ_WRITE;

    }
}

