/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.tools.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GroupDateCode
extends GroupRW {
    public GroupDateCode(ParamID weekID, ParamID yearID) {
        super(GroupType.DATE_CODE, List.of(weekID, yearID), GroupDateCode.getAllOptions());
    }

    private static List<String> getAllOptions() {
        ArrayList<String> dateCodes = new ArrayList<String>(5200);
        for (int year = 0; year <= 99; ++year) {
            for (int week = 1; week <= 52; ++week) {
                dateCodes.add(String.format("%02d%02d", year, week));
            }
        }
        return dateCodes;
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        Integer week = Helper.bcdToInt(registers.get(0));
        Integer year = Helper.bcdToInt(registers.get(1));
        return String.format("%02d%02d", year, week);
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        return Arrays.asList(Helper.intToBCD(Integer.parseInt(beautifulString.substring(2, 4))), Helper.intToBCD(Integer.parseInt(beautifulString.substring(0, 2))));
    }
}

