/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.FileResourcesManager;
import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import java.util.Arrays;
import java.util.List;

public class GroupHardVersion
extends GroupRW {
    public GroupHardVersion(ParamID sfcardMsbID, ParamID sfcardLsbID, ParamID revisionID) {
        super(GroupType.HARD_VERSION, List.of(sfcardMsbID, sfcardLsbID, revisionID), FileResourcesManager.getLinesFromResourceFile("spark/hard_versions.txt"));
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        return (registers.get(0) << 8 | registers.get(1)) + " REV " + String.valueOf(registers.get(2));
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        String[] parts = beautifulString.split(" REV ");
        int sfcardValue = Integer.parseInt(parts[0]);
        int msbValue = sfcardValue >> 8 & 0xFF;
        int lsbValue = sfcardValue & 0xFF;
        int revValue = Integer.parseInt(parts[1]);
        return Arrays.asList(msbValue, lsbValue, revValue);
    }
}

