/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.tools.Helper;
import java.util.ArrayList;
import java.util.List;

public abstract class GroupHourMinute
extends GroupRW {
    private static final List<String> timeSlots = GroupHourMinute.createTimeSlots();

    private static List<String> createTimeSlots() {
        ArrayList<String> slots = new ArrayList<String>();
        for (int hour = 0; hour < 24; ++hour) {
            for (int minute = 0; minute < 60; minute += 15) {
                String time = String.format("%02dh%02d", hour, minute);
                slots.add(time);
            }
        }
        return slots;
    }

    public GroupHourMinute(GroupType type, ParamID hourID, ParamID minID) {
        super(type, List.of(hourID, minID), timeSlots);
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        return String.format("%02d", Helper.bcdToInt(registers.get(0))) + "h" + String.format("%02d", Helper.bcdToInt(registers.get(1)));
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        if (!beautifulString.matches("\\d{2}h\\d{2}")) {
            return null;
        }
        int hour = Integer.parseInt(beautifulString.substring(0, 2));
        int minute = Integer.parseInt(beautifulString.substring(3));
        return List.of(Integer.valueOf(Helper.intToBCD(hour)), Integer.valueOf(Helper.intToBCD(minute)));
    }
}

