/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GroupIntensity
extends GroupRW {
    private static List<String> getAllOptions() {
        return IntStream.rangeClosed(0, 511).mapToObj(Integer::toString).collect(Collectors.toList());
    }

    public GroupIntensity(ParamID intensityMsbID, ParamID intensityLsbID) {
        super(GroupType.INTENSITY, List.of(intensityMsbID, intensityLsbID), GroupIntensity.getAllOptions());
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        return String.valueOf(registers.get(0) << 8 | registers.get(1));
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        try {
            int value = Integer.parseInt(beautifulString);
            return List.of(Integer.valueOf(value >> 8), Integer.valueOf(value & 0xFF));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }
}

