/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.tools.Helper;
import java.time.LocalDateTime;
import java.util.List;

public class GroupRTC
extends GroupRW {
    private static final String RTC_OPTION_NOW_NAME = "Now";

    public GroupRTC(ParamID secondID, ParamID minuteID, ParamID hourID, ParamID dayID, ParamID weekdayID, ParamID monthID, ParamID yearID) {
        super(GroupType.RTC, List.of(secondID, minuteID, hourID, dayID, weekdayID, monthID, yearID), List.of(RTC_OPTION_NOW_NAME));
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        Integer seconds = registers.get(0);
        Integer minutes = registers.get(1);
        Integer hours = registers.get(2);
        Integer day = registers.get(3);
        Integer weekday = registers.get(4);
        Integer month = registers.get(5);
        Integer year = registers.get(6);
        return String.format("%02d", Helper.bcdToInt(day)) + "/" + String.format("%02d", Helper.bcdToInt(month)) + "/" + (Helper.bcdToInt(year) + 2000) + " (" + Helper.bcdToInt(weekday) + ") - " + String.format("%02d", Helper.bcdToInt(hours)) + ":" + String.format("%02d", Helper.bcdToInt(minutes)) + ":" + String.format("%02d", Helper.bcdToInt(seconds));
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        switch (beautifulString) {
            case "Now": {
                LocalDateTime now = LocalDateTime.now();
                Integer sec = Helper.intToBCD(now.getSecond());
                Integer min = Helper.intToBCD(now.getMinute());
                Integer hour = Helper.intToBCD(now.getHour());
                Integer dayOfMonth = Helper.intToBCD(now.getDayOfMonth());
                Integer dayOfWeek = Helper.intToBCD(now.getDayOfWeek().getValue() % 7);
                Integer month = Helper.intToBCD(now.getMonthValue());
                Integer year = Helper.intToBCD(now.getYear() - 2000);
                return List.of(sec, min, hour, dayOfMonth, dayOfWeek, month, year);
            }
        }
        return null;
    }
}

