/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.FrameSender;
import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.Group;
import fr.orpheo.models.spark.protocol.groups.GroupRunnerEventListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GroupRunner {
    private final Group group;
    private final Set<GroupRunnerEventListener> listeners = new HashSet<GroupRunnerEventListener>();

    public GroupRunner(Group group) {
        this.group = group;
    }

    public String getName() {
        return this.group.getName();
    }

    public boolean read() {
        if (this.group == null || !this.group.isReadable()) {
            this.notifyOnGroupRead(null);
            return false;
        }
        ArrayList<Integer> registerValues = new ArrayList<Integer>();
        for (ParamID paramID : this.group.getParamIDs()) {
            Integer value = FrameSender.read(paramID);
            if (value == null) {
                this.notifyOnGroupRead(null);
                return false;
            }
            registerValues.add(value);
        }
        this.notifyOnGroupRead(this.group.getBeautifulString(registerValues));
        return true;
    }

    public boolean write(String beautifulString) {
        if (this.group == null || !this.group.isWritable()) {
            this.notifyOnGroupWritten(null);
            return false;
        }
        List<ParamID> paramIDs = this.group.getParamIDs();
        List<Integer> valuesToWrite = this.group.getVerifiedRegisterValues(beautifulString);
        if (valuesToWrite == null || paramIDs.size() != valuesToWrite.size()) {
            this.notifyOnGroupWritten(null);
            return false;
        }
        for (int i2 = 0; i2 < valuesToWrite.size(); ++i2) {
            if (FrameSender.write(paramIDs.get(i2), valuesToWrite.get(i2))) continue;
            this.notifyOnGroupWritten(null);
            return false;
        }
        this.notifyOnGroupWritten(beautifulString);
        return true;
    }

    private void notifyOnGroupRead(String result) {
        this.listeners.forEach(listener -> listener.onGroupRead(this.group, result));
    }

    private void notifyOnGroupWritten(String result) {
        this.listeners.forEach(listener -> listener.onGroupWritten(this.group, result));
    }

    public void register(GroupRunnerEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(GroupRunnerEventListener listener) {
        this.listeners.remove(listener);
    }
}

