/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.tools.Helper;
import java.time.LocalDateTime;
import java.util.List;

public class GroupTestDate
extends GroupRW {
    public static final String TEST_DATE_TODAY_NAME = "Today";

    public GroupTestDate(ParamID dayID, ParamID monthID, ParamID yearID) {
        super(GroupType.TEST_DATE, List.of(dayID, monthID, yearID), List.of(TEST_DATE_TODAY_NAME));
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        return String.format("%02d/%02d/%02d", Helper.bcdToInt(registers.get(0)), Helper.bcdToInt(registers.get(1)), Helper.bcdToInt(registers.get(2)));
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        switch (beautifulString) {
            case "Today": {
                LocalDateTime now = LocalDateTime.now();
                Integer day = Helper.intToBCD(now.getDayOfMonth());
                Integer month = Helper.intToBCD(now.getMonthValue());
                Integer year = Helper.intToBCD(now.getYear() - 2000);
                return List.of(day, month, year);
            }
        }
        return null;
    }
}

