/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol.groups;

import fr.orpheo.models.ZoneIdMapping;
import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.groups.GroupRW;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GroupZoneID
extends GroupRW {
    public GroupZoneID(ParamID byte1ID, ParamID byte2ID) {
        super(GroupType.ZONE_ID, List.of(byte1ID, byte2ID), GroupZoneID.getAllOptions());
    }

    private static List<String> getAllOptions() {
        return IntStream.rangeClosed(1, ZoneIdMapping.getNumberOfExistingPOI()).mapToObj(Integer::toString).collect(Collectors.toList());
    }

    @Override
    public String getBeautifulString(List<Integer> registers) {
        return String.valueOf(ZoneIdMapping.getVisitId(registers.get(0) << 8 | registers.get(1)));
    }

    @Override
    public List<Integer> getRegisterValues(String beautifulString) {
        try {
            int value = Integer.parseInt(beautifulString);
            int zoneIdRaw = ZoneIdMapping.getRawId(value);
            return List.of(Integer.valueOf(zoneIdRaw >> 8), Integer.valueOf(zoneIdRaw & 0xFF));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }
}

