/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.tests;

import fr.orpheo.models.tests.TestExecution;
import fr.orpheo.models.tests.TestRunnerEventListener;
import fr.orpheo.models.tests.TestStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TestRunner {
    private final List<TestExecution> allTests = new ArrayList<TestExecution>();
    private final Set<TestRunnerEventListener> listeners = new HashSet<TestRunnerEventListener>();

    public TestRunner(List<TestExecution> tests) {
        if (tests != null) {
            this.allTests.addAll(tests);
        }
    }

    public List<TestExecution> getTests() {
        return this.allTests;
    }

    public int getNumberOfTests() {
        return this.allTests.size();
    }

    public boolean add(TestExecution test) {
        return this.allTests.add(test);
    }

    public boolean addAll(Collection<? extends TestExecution> tests) {
        return this.allTests.addAll(tests);
    }

    public boolean runAllTests() {
        int testFailed = 0;
        for (TestExecution test : this.allTests) {
            test.setStarted();
            this.notifyOnTestChangedStatus(test);
            if (test.run() != TestStatus.PASSED) {
                ++testFailed;
            }
            this.notifyOnTestChangedStatus(test);
        }
        return testFailed == 0;
    }

    public void reset() {
        for (TestExecution test : this.allTests) {
            test.reset();
            this.notifyOnTestChangedStatus(test);
        }
    }

    public String toString() {
        Object s2 = "TestRunner:\n";
        for (TestExecution test : this.allTests) {
            s2 = (String)s2 + "\t" + String.valueOf(test) + "\n";
        }
        return s2;
    }

    private void notifyOnTestChangedStatus(TestExecution test) {
        this.listeners.forEach(listener -> listener.onTestChangedStatus(test));
    }

    public void register(TestRunnerEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(TestRunnerEventListener listener) {
        this.listeners.remove(listener);
    }
}

