/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.serial;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import fr.orpheo.models.GlobalBindings;
import fr.orpheo.serial.SerialPortEventListener;
import fr.orpheo.tools.FatalManager;
import fr.orpheo.tools.Helper;
import fr.orpheo.tools.PlatformSelector;
import fr.orpheo.tools.TaskManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SerialPortManager {
    private static final int SERIAL_BAUDRATE = 115200;
    private static SerialPort serialPort;
    private static volatile boolean connected;
    private static volatile boolean autoConnect;
    private static final Set<SerialPortEventListener> listeners;

    private SerialPortManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static synchronized boolean isConnected() {
        return connected;
    }

    public static synchronized void startAutoConnect() {
        if (autoConnect) {
            return;
        }
        autoConnect = true;
        TaskManager.runSimpleTask(() -> {
            SerialPortManager.notifyAutoDetectStarted();
            while (autoConnect) {
                if (!connected) {
                    SerialPortManager.openSerialPort();
                }
                Helper.delay(200L);
            }
            SerialPortManager.notifyAutoDetectStopped();
        });
    }

    public static synchronized void stopAutoConnect() {
        autoConnect = false;
    }

    private static SerialPort searchSerialPort() {
        if (serialPort != null) {
            return serialPort;
        }
        SerialPort[] availablePorts = SerialPort.getCommPorts();
        SerialPort matchedPort = null;
        for (SerialPort port : availablePorts) {
            if (!SerialPortManager.isFTDIPort(port)) continue;
            matchedPort = port;
        }
        return matchedPort;
    }

    private static boolean isFTDIPort(SerialPort port) {
        if (!"FTDI".equals(port.getManufacturer())) {
            return false;
        }
        String systemName = port.getSystemPortName();
        PlatformSelector platform = PlatformSelector.detect();
        return switch (platform) {
            case PlatformSelector.WINDOWS -> systemName.contains("COM");
            case PlatformSelector.LINUX, PlatformSelector.MAC -> systemName.contains("tty");
            default -> throw new UnsupportedOperationException("Unsupported platform: " + String.valueOf((Object)platform));
        };
    }

    public static String getSerialPortSystemName() {
        SerialPort searchPort = SerialPortManager.searchSerialPort();
        return searchPort != null ? searchPort.getSystemPortName() : null;
    }

    public static synchronized Boolean openSerialPort() {
        serialPort = SerialPortManager.searchSerialPort();
        if (serialPort == null) {
            return false;
        }
        SerialPortManager.notifyPortOpening();
        serialPort.setBaudRate(115200);
        if (!serialPort.openPort()) {
            SerialPortManager.notifyPortWarning("Failed to open the port");
            return false;
        }
        SerialPortDataListener dataListener = new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 0x10000001;
            }

            @Override
            public void serialEvent(SerialPortEvent event) {
                if (event.getEventType() == 1) {
                    byte[] data = SerialPortManager.readAllAccessibleBytes();
                    SerialPortManager.notifyDataReceived(data);
                } else if (event.getEventType() == 0x10000000) {
                    SerialPortManager.closeSerialPort();
                }
            }
        };
        serialPort.addDataListener(dataListener);
        SerialPortManager.notifyPortOpened();
        GlobalBindings.setConnected(true);
        connected = true;
        return true;
    }

    public static synchronized void closeSerialPort() {
        if (serialPort != null && serialPort.isOpen()) {
            if (!serialPort.closePort()) {
                FatalManager.fatalError("Impossible to close the serial port.");
            } else {
                serialPort = null;
                SerialPortManager.notifyPortClosed();
                connected = false;
                GlobalBindings.setConnected(false);
            }
        }
    }

    private static synchronized byte[] readAllAccessibleBytes() {
        if (serialPort != null && serialPort.isOpen()) {
            int available = serialPort.bytesAvailable();
            if (available <= 0) {
                return new byte[0];
            }
            int bufferSize = Math.min(available, 256);
            byte[] newData = new byte[bufferSize];
            int numRead = serialPort.readBytes(newData, bufferSize);
            if (numRead > 0) {
                return Arrays.copyOf(newData, numRead);
            }
        }
        return new byte[0];
    }

    public static synchronized boolean sendBytes(byte[] byteArray) {
        if (serialPort != null && serialPort.isOpen()) {
            try {
                serialPort.getOutputStream().write(byteArray);
                serialPort.getOutputStream().flush();
                SerialPortManager.notifyDataSent(byteArray);
                return true;
            }
            catch (Exception e2) {
                SerialPortManager.notifyPortWarning("Failed to send data");
                e2.printStackTrace();
            }
        }
        return false;
    }

    private static void notifyPortOpened() {
        listeners.forEach(listener -> listener.onPortOpened(serialPort));
    }

    private static void notifyPortOpening() {
        listeners.forEach(listener -> listener.onPortOpening(serialPort));
    }

    private static void notifyPortClosed() {
        listeners.forEach(listener -> listener.onPortClosed());
    }

    private static void notifyPortWarning(String message) {
        listeners.forEach(listener -> listener.onPortWarning(message));
    }

    private static void notifyAutoDetectStarted() {
        listeners.forEach(listener -> listener.onAutoConnectStarted());
    }

    private static void notifyAutoDetectStopped() {
        listeners.forEach(listener -> listener.onAutoConnectStopped());
    }

    private static void notifyDataSent(byte[] data) {
        listeners.forEach(listener -> listener.onDataSent(data));
    }

    private static void notifyDataReceived(byte[] data) {
        listeners.forEach(listener -> listener.onDataReceived(data));
    }

    public static void register(SerialPortEventListener listener) {
        listeners.add(listener);
    }

    public static void unregister(SerialPortEventListener listener) {
        listeners.remove(listener);
    }

    static {
        connected = false;
        autoConnect = false;
        listeners = new HashSet<SerialPortEventListener>();
    }
}

