/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.stm32cli;

import fr.orpheo.FileResourcesManager;
import fr.orpheo.serial.SerialPortManager;
import fr.orpheo.stm32cli.Stm32CliEventListener;
import fr.orpheo.tools.ConsoleLogger;
import fr.orpheo.tools.PlatformSelector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Stm32CliExecutor {
    private static SparkBinary currentFlashBinary = null;
    private static final Set<Stm32CliEventListener> listeners = new HashSet<Stm32CliEventListener>();

    private Stm32CliExecutor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static synchronized boolean flashSpark(SparkBinary binary, String versionString) {
        File stm32ProgrammerCLI;
        File sparkBinary;
        currentFlashBinary = binary;
        Stm32CliExecutor.notifyFlashStarted();
        Matcher matcher = Pattern.compile("(\\d+).(\\d+)").matcher(versionString);
        if (!matcher.find()) {
            Stm32CliExecutor.notifyFlashError("Incorrect version format: " + versionString);
            return false;
        }
        String serialPortName = SerialPortManager.getSerialPortSystemName();
        if (serialPortName == null) {
            Stm32CliExecutor.notifyFlashError("No port detected");
            return false;
        }
        PlatformSelector platform = PlatformSelector.detect();
        try {
            Object sparkBinaryPath = switch (binary.ordinal()) {
                case 0 -> "STM32/Spark_binaries/Spark_setup_software";
                case 1 -> "STM32/Spark_binaries/Spark_flow_software";
                default -> throw new UnsupportedOperationException("Invalid program name: " + String.valueOf((Object)binary));
            };
            sparkBinaryPath = (String)sparkBinaryPath + "_" + matcher.group(1) + "_" + matcher.group(2) + ".elf";
            String resourcePath = switch (platform) {
                case PlatformSelector.WINDOWS -> "STM32/windows/";
                case PlatformSelector.LINUX -> "STM32/linux/";
                case PlatformSelector.MAC -> "STM32/mac/";
                default -> throw new UnsupportedOperationException("Unsupported platform: " + String.valueOf((Object)platform));
            };
            sparkBinary = FileResourcesManager.extractFile((String)sparkBinaryPath, false);
            stm32ProgrammerCLI = Stm32CliExecutor.extractSTM32ProgrammerCLI(resourcePath);
        }
        catch (Exception e2) {
            Stm32CliExecutor.notifyFlashError("Failed to extract the ressources. " + e2.getMessage());
            return false;
        }
        SerialPortManager.stopAutoConnect();
        SerialPortManager.closeSerialPort();
        ArrayList<String> programSparkCommand = new ArrayList<String>();
        programSparkCommand.add(stm32ProgrammerCLI.getAbsolutePath());
        programSparkCommand.add("-c");
        programSparkCommand.add("port=" + serialPortName);
        programSparkCommand.add("br=921600");
        programSparkCommand.add("-w");
        programSparkCommand.add(sparkBinary.getAbsolutePath());
        programSparkCommand.add("-v");
        programSparkCommand.add("-ob");
        programSparkCommand.add("nBOOT_SEL=0");
        programSparkCommand.add("-s");
        programSparkCommand.add("-q");
        int code = Stm32CliExecutor.executeCommand(programSparkCommand);
        SerialPortManager.openSerialPort();
        SerialPortManager.startAutoConnect();
        currentFlashBinary = null;
        return code == 0;
    }

    private static synchronized int executeCommand(List<String> commands) {
        int exitCode = -1;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        try {
            String line;
            processBuilder.command(commands);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Stm32CliExecutor.handleCommandOutput(line);
            }
            if (process.waitFor(20L, TimeUnit.SECONDS)) {
                exitCode = process.waitFor();
            } else {
                process.destroy();
            }
        }
        catch (IOException e2) {
            ConsoleLogger.error("IOException while executing command: ");
            e2.printStackTrace();
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            ConsoleLogger.error("InterruptedException while executing command: ");
            e3.printStackTrace();
        }
        return exitCode;
    }

    private static synchronized void handleCommandOutput(String line) {
        if (line.contains("Error")) {
            Stm32CliExecutor.notifyFlashError(line);
        } else if (line.contains("Download in Progress")) {
            Stm32CliExecutor.notifyDownloadStarted();
        } else if (line.contains("Verifying")) {
            Stm32CliExecutor.notifyVerifyStarted();
        } else if (line.contains("RUNNING Program")) {
            Stm32CliExecutor.notifyFlashSuccess();
        }
    }

    private static synchronized File extractSTM32ProgrammerCLI(String resourcePath) throws IOException {
        File stm32programmer = null;
        List<String> requiredFiles = FileResourcesManager.getLinesFromResourceFile(resourcePath + "required_files.txt");
        for (String fileName : requiredFiles) {
            if (fileName.contains("Programmer")) {
                stm32programmer = FileResourcesManager.extractFile(resourcePath + fileName, true);
                continue;
            }
            FileResourcesManager.extractFile(resourcePath + fileName, false);
        }
        FileResourcesManager.extractFile("STM32/Data_Base/STM32_Prog_DB_0x453.xml", false);
        if (stm32programmer == null) {
            throw new FileNotFoundException("No executable file found.");
        }
        return stm32programmer;
    }

    private static void notifyFlashStarted() {
        listeners.forEach(listener -> listener.onFlashStarted(currentFlashBinary));
    }

    private static void notifyDownloadStarted() {
        listeners.forEach(listener -> listener.onDownloadStarted(currentFlashBinary));
    }

    private static void notifyVerifyStarted() {
        listeners.forEach(listener -> listener.onVerifyStarted(currentFlashBinary));
    }

    private static void notifyFlashSuccess() {
        listeners.forEach(listener -> listener.onFlashSuccess(currentFlashBinary));
    }

    private static void notifyFlashError(String message) {
        listeners.forEach(listener -> listener.onFlashError(currentFlashBinary, message));
    }

    public static void register(Stm32CliEventListener listener) {
        listeners.add(listener);
    }

    public static void unregister(Stm32CliEventListener listener) {
        listeners.remove(listener);
    }

    public static enum SparkBinary {
        SETUP,
        FLOW;

    }
}

