/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.tools;

import com.fazecast.jSerialComm.SerialPort;
import fr.orpheo.models.spark.SparkInitializer;
import fr.orpheo.models.spark.SparkInitializerEventListener;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.models.tests.TestExecution;
import fr.orpheo.models.tests.TestRunner;
import fr.orpheo.serial.SerialPortEventListener;
import fr.orpheo.serial.SerialPortManager;
import fr.orpheo.stm32cli.Stm32CliEventListener;
import fr.orpheo.stm32cli.Stm32CliExecutor;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.TextArea;

public class ConsoleLogger
implements Stm32CliEventListener,
SerialPortEventListener,
SparkInitializerEventListener {
    private static TextArea console;
    private static final List<LoggingLevel> usedLoggings;

    private ConsoleLogger() {
        SparkInitializer.register(this);
        SerialPortManager.register(this);
        Stm32CliExecutor.register(this);
    }

    public static void bindConsole(TextArea consoleArea) {
        console = consoleArea;
        System.setOut(new PrintStream(new ConsoleOutputStream(LoggingLevel.INFO)));
        System.setErr(new PrintStream(new ConsoleOutputStream(LoggingLevel.ERROR)));
    }

    public static void trace(String message) {
        ConsoleLogger.appendToConsole(LoggingLevel.TRACE, message);
    }

    public static void debug(String message) {
        ConsoleLogger.appendToConsole(LoggingLevel.DEBUG, message);
    }

    public static void info(String message) {
        ConsoleLogger.appendToConsole(LoggingLevel.INFO, message);
    }

    public static void warn(String message) {
        ConsoleLogger.appendToConsole(LoggingLevel.WARN, message);
    }

    public static void error(String message) {
        ConsoleLogger.appendToConsole(LoggingLevel.ERROR, message);
    }

    public static void fatal(String message) {
        ConsoleLogger.appendToConsole(LoggingLevel.FATAL, message);
    }

    private static void appendToConsole(LoggingLevel level, String message) {
        if (console != null && usedLoggings.contains((Object)level)) {
            Platform.runLater(() -> console.appendText(level.name() + ": " + message + "\n"));
        }
    }

    private void initInfo(String message) {
        ConsoleLogger.info("INIT => " + message);
    }

    private void initError(String message) {
        ConsoleLogger.error("INIT => " + message);
    }

    @Override
    public void onInitStarted() {
        this.initInfo("Started");
    }

    @Override
    public void onInitTestsLoaded(TestRunner runner) {
        this.initInfo("Tests loaded");
    }

    @Override
    public void onInitTestRan(TestExecution test, float advancement) {
        this.initInfo("Test " + test.getName() + " " + String.valueOf((Object)test.getStatus()));
    }

    @Override
    public void onInitGroupSet(GroupType groupType, float advancement) {
        this.initInfo("Group " + groupType.getName() + " SET");
    }

    @Override
    public void onInitSaved() {
        this.initInfo("Saved and quitted");
    }

    @Override
    public void onInitSuccess() {
        this.initInfo("Success!");
    }

    @Override
    public void onInitError(String message) {
        this.initError(message);
    }

    private void serialInfo(String message) {
        ConsoleLogger.info("SERIAL => " + message);
    }

    private void serialWarning(String message) {
        ConsoleLogger.warn("SERIAL => " + message);
    }

    @Override
    public void onPortOpened(SerialPort serialPort) {
        this.serialInfo("Port opened (" + serialPort.getDescriptivePortName() + ")");
    }

    @Override
    public void onPortOpening(SerialPort serialPort) {
        this.serialInfo("Port opening (" + serialPort.getDescriptivePortName() + ")");
    }

    @Override
    public void onPortClosed() {
        this.serialInfo("Port closed");
    }

    @Override
    public void onPortWarning(String message) {
        this.serialWarning(message);
    }

    @Override
    public void onAutoConnectStarted() {
        this.serialInfo("AutoConnect started");
    }

    @Override
    public void onAutoConnectStopped() {
        this.serialInfo("AutoConnect stopped");
    }

    @Override
    public void onDataSent(byte[] data) {
    }

    @Override
    public void onDataReceived(byte[] data) {
    }

    private void flashInfo(Stm32CliExecutor.SparkBinary binary, String message) {
        ConsoleLogger.info("FLASH => " + String.valueOf((Object)binary) + " " + message);
    }

    private void flashError(Stm32CliExecutor.SparkBinary binary, String message) {
        ConsoleLogger.error("FLASH => " + String.valueOf((Object)binary) + " " + message);
    }

    @Override
    public void onFlashStarted(Stm32CliExecutor.SparkBinary binary) {
        this.flashInfo(binary, "Started");
    }

    @Override
    public void onDownloadStarted(Stm32CliExecutor.SparkBinary binary) {
        this.flashInfo(binary, "Download");
    }

    @Override
    public void onVerifyStarted(Stm32CliExecutor.SparkBinary binary) {
        this.flashInfo(binary, "Verify");
    }

    @Override
    public void onFlashSuccess(Stm32CliExecutor.SparkBinary binary) {
        this.flashInfo(binary, "Success!");
    }

    @Override
    public void onFlashError(Stm32CliExecutor.SparkBinary binary, String message) {
        this.flashError(binary, message);
    }

    static {
        usedLoggings = new ArrayList<LoggingLevel>(Arrays.asList(LoggingLevel.DEBUG, LoggingLevel.INFO, LoggingLevel.WARN, LoggingLevel.ERROR, LoggingLevel.FATAL));
        new ConsoleLogger();
    }

    private static class ConsoleOutputStream
    extends OutputStream {
        private final LoggingLevel level;

        public ConsoleOutputStream(LoggingLevel level) {
            this.level = level;
        }

        @Override
        public void write(int b2) {
            ConsoleLogger.appendToConsole(this.level, String.valueOf((char)b2));
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            ConsoleLogger.appendToConsole(this.level, new String(b2, off, len));
        }
    }

    private static enum LoggingLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

