/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.tools;

import java.nio.charset.StandardCharsets;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class Helper {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public static Integer parseByte(String part) {
        try {
            int value = part.toLowerCase().startsWith("0x") ? Integer.parseInt(part.substring(2), 16) : Integer.parseInt(part);
            return value >= 0 && value <= 255 ? Integer.valueOf(value) : null;
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static void applyBorderColor(Region field, boolean success) {
        if (field == null) {
            return;
        }
        Platform.runLater(() -> {
            String style = success ? "config-field-success" : "config-field-error";
            field.getStyleClass().remove(success ? "config-field-error" : "config-field-success");
            field.getStyleClass().add(style);
            PauseTransition pause = new PauseTransition(Duration.seconds(1.0));
            pause.setOnFinished(actionEvent -> Platform.runLater(() -> field.getStyleClass().remove(style)));
            pause.play();
        });
    }

    public static int intToBCD(int number) {
        if (number < 0 || number >= 100) {
            throw new IllegalArgumentException("Number must be between 0 and 99.");
        }
        int tens = number / 10 << 4;
        int ones = number % 10;
        return tens | ones;
    }

    public static int bcdToInt(int bcd) {
        if ((bcd & 0xF0) > 144 || (bcd & 0xF) > 9) {
            throw new IllegalArgumentException("Invalid BCD value.");
        }
        int tens = (bcd >> 4) * 10;
        int ones = bcd & 0xF;
        return tens + ones;
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 3];
        for (int j2 = 0; j2 < bytes.length; ++j2) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 3] = HEX_ARRAY[v >>> 4];
            hexChars[j2 * 3 + 1] = HEX_ARRAY[v & 0xF];
            hexChars[j2 * 3 + 2] = 32;
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static void delay(long milli) {
        try {
            Thread.sleep(milli);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }
}

