/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.tools;

import fr.orpheo.models.GlobalBindings;
import java.util.ArrayList;
import java.util.List;

public class TaskManager {
    private static final List<Thread> activeThreads = new ArrayList<Thread>();

    private TaskManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void runSimpleTask(Runnable task) {
        Thread thread = new Thread(() -> {
            try {
                task.run();
            }
            catch (Exception e2) {
                System.err.println("Task execution error: " + e2.getMessage());
            }
            finally {
                TaskManager.removeFinishedThreads();
            }
        });
        activeThreads.add(thread);
        thread.start();
    }

    public static void stopAllTasks() {
        for (Thread thread : activeThreads) {
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
        activeThreads.clear();
    }

    private static void removeFinishedThreads() {
        activeThreads.removeIf(thread -> !thread.isAlive());
    }

    public static void performLongAction(Runnable task) {
        TaskManager.runSimpleTask(() -> {
            try {
                GlobalBindings.setPerformingAction(true);
                task.run();
            }
            finally {
                GlobalBindings.setPerformingAction(false);
            }
        });
    }
}

