/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import java.util.Collection;
import java.util.Iterator;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.SetBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableSetValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;

public abstract class SetExpression<E>
implements ObservableSetValue<E> {
    @Override
    public ObservableSet<E> getValue() {
        return (ObservableSet)this.get();
    }

    public static <E> SetExpression<E> setExpression(final ObservableSetValue<E> observableSetValue) {
        if (observableSetValue == null) {
            throw new NullPointerException("Set must be specified.");
        }
        return observableSetValue instanceof SetExpression ? (SetExpression<E>)observableSetValue : new SetBinding<E>(){
            {
                super.bind(observableSetValue);
            }

            @Override
            public void dispose() {
                super.unbind(observableSetValue);
            }

            @Override
            protected ObservableSet<E> computeValue() {
                return (ObservableSet)observableSetValue.get();
            }

            @Override
            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList(observableSetValue);
            }
        };
    }

    public int getSize() {
        return this.size();
    }

    public abstract ReadOnlyIntegerProperty sizeProperty();

    public abstract ReadOnlyBooleanProperty emptyProperty();

    public BooleanBinding isEqualTo(ObservableSet<?> observableSet) {
        return Bindings.equal(this, observableSet);
    }

    public BooleanBinding isNotEqualTo(ObservableSet<?> observableSet) {
        return Bindings.notEqual(this, observableSet);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull(this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull(this);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }

    @Override
    public int size() {
        return this.getNonNull().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getNonNull().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.getNonNull().contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getNonNull().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getNonNull().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.getNonNull().toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        return this.getNonNull().add(e2);
    }

    @Override
    public boolean remove(Object object) {
        return this.getNonNull().remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getNonNull().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.getNonNull().addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getNonNull().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getNonNull().retainAll(collection);
    }

    @Override
    public void clear() {
        this.getNonNull().clear();
    }

    private ObservableSet<E> getNonNull() {
        ObservableSet observableSet = (ObservableSet)this.get();
        return observableSet == null ? FXCollections.emptyObservableSet() : observableSet;
    }
}

