/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ListListenerHelper;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeBuilder;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class ObservableListBase<E>
extends AbstractList<E>
implements ObservableList<E> {
    private ListListenerHelper<E> listenerHelper;
    private ListChangeBuilder<E> changeBuilder;

    protected final void nextUpdate(int n2) {
        this.getListChangeBuilder().nextUpdate(n2);
    }

    protected final void nextSet(int n2, E e2) {
        this.getListChangeBuilder().nextSet(n2, e2);
    }

    protected final void nextReplace(int n2, int n3, List<? extends E> list) {
        this.getListChangeBuilder().nextReplace(n2, n3, list);
    }

    protected final void nextRemove(int n2, List<? extends E> list) {
        this.getListChangeBuilder().nextRemove(n2, list);
    }

    protected final void nextRemove(int n2, E e2) {
        this.getListChangeBuilder().nextRemove(n2, e2);
    }

    protected final void nextPermutation(int n2, int n3, int[] nArray) {
        this.getListChangeBuilder().nextPermutation(n2, n3, nArray);
    }

    protected final void nextAdd(int n2, int n3) {
        this.getListChangeBuilder().nextAdd(n2, n3);
    }

    protected final void beginChange() {
        this.getListChangeBuilder().beginChange();
    }

    protected final void endChange() {
        this.getListChangeBuilder().endChange();
    }

    private ListChangeBuilder<E> getListChangeBuilder() {
        if (this.changeBuilder == null) {
            this.changeBuilder = new ListChangeBuilder(this);
        }
        return this.changeBuilder;
    }

    @Override
    public final void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public final void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public final void addListener(ListChangeListener<? super E> listChangeListener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, listChangeListener);
    }

    @Override
    public final void removeListener(ListChangeListener<? super E> listChangeListener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, listChangeListener);
    }

    protected final void fireChange(ListChangeListener.Change<? extends E> change) {
        ListListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    protected final boolean hasListeners() {
        return ListListenerHelper.hasListeners(this.listenerHelper);
    }

    @Override
    public boolean addAll(E ... EArray) {
        return this.addAll(Arrays.asList(EArray));
    }

    @Override
    public boolean setAll(E ... EArray) {
        return this.setAll((Collection<? extends E>)Arrays.asList(EArray));
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(E ... EArray) {
        return this.removeAll((Collection<?>)Arrays.asList(EArray));
    }

    @Override
    public boolean retainAll(E ... EArray) {
        return this.retainAll((Collection<?>)Arrays.asList(EArray));
    }

    @Override
    public void remove(int n2, int n3) {
        this.removeRange(n2, n3);
    }
}

