/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableDoubleProperty
extends DoublePropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableDoubleProperty() {
    }

    public StyleableDoubleProperty(double d2) {
        super(d2);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        double d2;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        double d3 = d2 = number != null ? number.doubleValue() : 0.0;
        if (transitionDefinition == null) {
            this.set(d2);
        } else if (this.mediator == null || this.mediator.endValue != d2) {
            this.mediator = new TransitionMediatorImpl(this.get(), d2);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    @Override
    public void set(double d2) {
        super.set(d2);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final double startValue;
        private final double endValue;
        private double reversingAdjustedStartValue;

        public TransitionMediatorImpl(double d2, double d3) {
            this.startValue = d2;
            this.endValue = d3;
            this.reversingAdjustedStartValue = d2;
        }

        @Override
        public void onUpdate(double d2) {
            StyleableDoubleProperty.super.set(d2 < 1.0 ? this.startValue + (this.endValue - this.startValue) * d2 : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableDoubleProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableDoubleProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

