/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableIntegerProperty
extends IntegerPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableIntegerProperty() {
    }

    public StyleableIntegerProperty(int n2) {
        super(n2);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        int n2;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        int n3 = n2 = number != null ? number.intValue() : 0;
        if (transitionDefinition == null) {
            this.set(n2);
        } else if (this.mediator == null || this.mediator.endValue != n2) {
            this.mediator = new TransitionMediatorImpl(this.get(), n2);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    @Override
    public void set(int n2) {
        super.set(n2);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final int startValue;
        private final int endValue;
        private int reversingAdjustedStartValue;

        public TransitionMediatorImpl(int n2, int n3) {
            this.startValue = n2;
            this.endValue = n3;
            this.reversingAdjustedStartValue = n2;
        }

        @Override
        public void onUpdate(double d2) {
            StyleableIntegerProperty.super.set(d2 < 1.0 ? (int)Math.round((double)this.startValue + (double)(this.endValue - this.startValue) * d2) : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableIntegerProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableIntegerProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

