/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableLongProperty
extends LongPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableLongProperty() {
    }

    public StyleableLongProperty(long l2) {
        super(l2);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        long l2;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        long l3 = l2 = number != null ? number.longValue() : 0L;
        if (transitionDefinition == null) {
            this.set(l2);
        } else if (this.mediator == null || this.mediator.endValue != l2) {
            this.mediator = new TransitionMediatorImpl(this.get(), l2);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    @Override
    public void set(long l2) {
        super.set(l2);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final long startValue;
        private final long endValue;
        private long reversingAdjustedStartValue;

        public TransitionMediatorImpl(long l2, long l3) {
            this.startValue = l2;
            this.endValue = l3;
            this.reversingAdjustedStartValue = l2;
        }

        @Override
        public void onUpdate(double d2) {
            long l2 = this.endValue - this.startValue;
            long l3 = this.startValue + Math.round(d2 * (double)l2);
            StyleableLongProperty.super.set(d2 < 1.0 ? Utils.clamp(this.startValue, l3, this.endValue) : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableLongProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableLongProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

