/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.SubPropertyConverter;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.css.TransitionTimer;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.InterpolationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableObjectProperty<T>
extends ObjectPropertyBase<T>
implements StyleableProperty<T> {
    private StyleOrigin origin;
    private TransitionController<T> controller;

    public StyleableObjectProperty() {
    }

    public StyleableObjectProperty(T t2) {
        super(t2);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, T t2) {
        CssMetaData cssMetaData = this.getCssMetaData();
        StyleConverter styleConverter = cssMetaData.getConverter();
        Object t3 = this.get();
        if (t3 != null && t2 != null && styleConverter instanceof SubPropertyConverter) {
            SubPropertyConverter subPropertyConverter = (SubPropertyConverter)((Object)styleConverter);
            this.applyComponents(t3, t2, cssMetaData, subPropertyConverter);
        } else {
            this.applyValue(t3, t2, cssMetaData);
        }
        this.origin = styleOrigin;
    }

    private void applyValue(T t2, T t3, CssMetaData<? extends Styleable, T> cssMetaData) {
        Object object;
        TransitionDefinition transitionDefinition;
        Object object2 = this.getBean();
        TransitionDefinition transitionDefinition2 = transitionDefinition = object2 instanceof Node && !NodeHelper.isInitialCssState((Node)(object = (Node)object2)) ? NodeHelper.findTransitionDefinition((Node)object, cssMetaData) : null;
        if (transitionDefinition == null) {
            this.set(t3);
        } else if (this.controller == null || !Objects.equals(t3, this.controller.getTargetValue())) {
            object = t2 instanceof Interpolatable && t3 instanceof Interpolatable && t3.getClass().isInstance(t2) ? new InterpolatableTransitionController(t2, t3) : new DiscreteTransitionController(t2, t3);
            this.controller = object;
            ((TransitionMediator)object).run(transitionDefinition, cssMetaData.getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
    }

    private void applyComponents(T t2, T t3, CssMetaData<? extends Styleable, T> cssMetaData, SubPropertyConverter<T> subPropertyConverter) {
        Object object;
        Map<CssMetaData<? extends Styleable, ?>, Object> map = this.getBean();
        Map<CssMetaData<Styleable, ?>, TransitionDefinition> map2 = map instanceof Node && !NodeHelper.isInitialCssState((Node)(object = (Node)((Object)map))) ? NodeHelper.findTransitionDefinitions((Node)object, cssMetaData) : null;
        object = cssMetaData.getSubProperties();
        if (map2 == null || map2.isEmpty() || object == null || object.isEmpty()) {
            this.set(t3);
        } else if (this.controller == null || !Objects.equals(t3, this.controller.getTargetValue())) {
            map = subPropertyConverter.convertBack(t2);
            Map<CssMetaData<? extends Styleable, ?>, Object> map3 = subPropertyConverter.convertBack(t3);
            AggregatingTransitionController aggregatingTransitionController = new AggregatingTransitionController(t3);
            int n2 = object.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.processComponent(aggregatingTransitionController, (CssMetaData)object.get(i2), map2, map, map3);
            }
            this.controller = aggregatingTransitionController;
            aggregatingTransitionController.run();
        }
    }

    private void processComponent(AggregatingTransitionController aggregatingTransitionController, CssMetaData<? extends Styleable, ?> cssMetaData, Map<CssMetaData<? extends Styleable, ?>, TransitionDefinition> map, Map<CssMetaData<? extends Styleable, ?>, Object> map2, Map<CssMetaData<? extends Styleable, ?>, Object> map3) {
        Object object;
        Object object2;
        Object object3 = map2.get(cssMetaData);
        if (Objects.deepEquals(object3, object2 = map3.get(cssMetaData))) {
            aggregatingTransitionController.addValue(cssMetaData, object3);
        } else {
            TransitionMediator transitionMediator;
            TransitionMediator transitionMediator2;
            object = map.get(cssMetaData);
            TransitionTimer transitionTimer = NodeHelper.findTransitionTimer((Node)this.getBean(), cssMetaData.getProperty());
            if (transitionTimer != null && (transitionMediator2 = transitionTimer.getMediator()) instanceof ComponentTransitionMediator) {
                ComponentTransitionMediator componentTransitionMediator = (ComponentTransitionMediator)transitionMediator2;
                v0 = componentTransitionMediator;
            } else {
                v0 = transitionMediator = null;
            }
            if (transitionMediator != null) {
                if (object == null) {
                    transitionMediator.cancel();
                    aggregatingTransitionController.addValue(cssMetaData, object2);
                } else if (Objects.deepEquals(object2, ((ComponentTransitionMediator)transitionMediator).endValue)) {
                    aggregatingTransitionController.addExistingMediator(transitionMediator);
                } else {
                    aggregatingTransitionController.addMediator(object3, object2, cssMetaData, (TransitionDefinition)object);
                }
            } else if (object != null) {
                aggregatingTransitionController.addMediator(object3, object2, cssMetaData, (TransitionDefinition)object);
            } else {
                aggregatingTransitionController.addValue(cssMetaData, object2);
            }
        }
        object = cssMetaData.getSubProperties();
        if (object != null) {
            int n2 = object.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.processComponent(aggregatingTransitionController, (CssMetaData)object.get(i2), map, map2, map3);
            }
        }
    }

    @Override
    public void bind(ObservableValue<? extends T> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    @Override
    public void set(T t2) {
        super.set(t2);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.controller != null) {
            this.controller.cancel();
        }
    }

    private static interface TransitionController<T> {
        public T getTargetValue();

        public void cancel();
    }

    private final class InterpolatableTransitionController
    extends TransitionControllerBase {
        InterpolatableTransitionController(T t2, T t3) {
            super(t2, t3);
        }

        @Override
        public void onUpdate(double d2) {
            StyleableObjectProperty.super.set(d2 < 1.0 ? ((Interpolatable)this.startValue).interpolate(this.endValue, d2) : this.endValue);
        }
    }

    private final class DiscreteTransitionController
    extends TransitionControllerBase {
        DiscreteTransitionController(T t2, T t3) {
            super(t2, t3);
        }

        @Override
        public void onUpdate(double d2) {
            StyleableObjectProperty.super.set(d2 < 0.5 ? this.startValue : this.endValue);
        }
    }

    private abstract class TransitionControllerBase
    extends TransitionMediator
    implements TransitionController<T> {
        final T startValue;
        final T endValue;
        private T reversingAdjustedStartValue;

        TransitionControllerBase(T t2, T t3) {
            this.startValue = t2;
            this.endValue = t3;
            this.reversingAdjustedStartValue = t2;
        }

        @Override
        public void onStop() {
            StyleableObjectProperty.this.controller = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableObjectProperty.this;
        }

        @Override
        public T getTargetValue() {
            return this.endValue;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionControllerBase transitionControllerBase = (TransitionControllerBase)transitionMediator;
            if (Objects.deepEquals(transitionControllerBase.reversingAdjustedStartValue, this.endValue)) {
                this.reversingAdjustedStartValue = transitionControllerBase.endValue;
                return true;
            }
            return false;
        }
    }

    private final class AggregatingTransitionController
    implements TransitionController<T> {
        private final T newValue;
        private final Map<CssMetaData<? extends Styleable, ?>, Object> cssValues;
        private final List<ComponentTransitionMediator<?>> mediators = new ArrayList(5);
        private int remainingValues;

        AggregatingTransitionController(T t2) {
            this.newValue = t2;
            this.cssValues = new HashMap();
        }

        @Override
        public T getTargetValue() {
            return this.newValue;
        }

        @Override
        public void cancel() {
            for (ComponentTransitionMediator<?> componentTransitionMediator : List.copyOf(this.mediators)) {
                componentTransitionMediator.cancel();
            }
        }

        public void run() {
            this.remainingValues = this.mediators.size();
            long l2 = Toolkit.getToolkit().getPrimaryTimer().nanos();
            for (ComponentTransitionMediator<?> componentTransitionMediator : List.copyOf(this.mediators)) {
                componentTransitionMediator.run(l2);
            }
        }

        public void addValue(CssMetaData<? extends Styleable, ?> cssMetaData, Object object) {
            this.cssValues.put(cssMetaData, object);
        }

        public <U> void addMediator(U u2, U u3, CssMetaData<? extends Styleable, ?> cssMetaData, TransitionDefinition transitionDefinition) {
            this.mediators.add(new ComponentTransitionMediator<U>(u2, u3, this, cssMetaData, transitionDefinition));
        }

        public <U> void addExistingMediator(ComponentTransitionMediator<U> componentTransitionMediator) {
            componentTransitionMediator.associatedController = this;
            this.mediators.add(componentTransitionMediator);
        }

        public void onUpdate(CssMetaData<? extends Styleable, ?> cssMetaData, Object object) {
            this.cssValues.put(cssMetaData, object);
            if (--this.remainingValues == 0) {
                this.remainingValues = this.mediators.size();
                StyleableObjectProperty.super.set(StyleableObjectProperty.this.getCssMetaData().getConverter().convert(this.cssValues));
            }
        }

        public void onStop(ComponentTransitionMediator<?> componentTransitionMediator) {
            int n2 = this.mediators.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.mediators.get(i2) != componentTransitionMediator) continue;
                this.mediators.remove(i2);
                break;
            }
            if (this.mediators.isEmpty()) {
                StyleableObjectProperty.this.controller = null;
            }
        }
    }

    private final class ComponentTransitionMediator<U>
    extends TransitionMediator {
        private final U startValue;
        private final U endValue;
        private final CssMetaData<? extends Styleable, ?> metadata;
        private final TransitionDefinition definition;
        private AggregatingTransitionController associatedController;
        private U reversingAdjustedStartValue;
        private boolean running;

        ComponentTransitionMediator(U u2, U u3, AggregatingTransitionController aggregatingTransitionController, CssMetaData<? extends Styleable, ?> cssMetaData, TransitionDefinition transitionDefinition) {
            this.startValue = u2;
            this.endValue = u3;
            this.reversingAdjustedStartValue = u2;
            this.associatedController = aggregatingTransitionController;
            this.metadata = cssMetaData;
            this.definition = transitionDefinition;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableObjectProperty.this;
        }

        public void run(long l2) {
            if (!this.running) {
                this.running = true;
                this.run(this.definition, this.metadata.getProperty(), l2);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void onUpdate(double var1_1) {
            block4: {
                block2: {
                    block3: {
                        if (!(var1_1 < 1.0)) break block2;
                        var8_2 = this.startValue;
                        if (!(var8_2 instanceof Interpolatable[][])) break block3;
                        var4_3 = (Interpolatable[][])var8_2;
                        var8_2 = this.endValue;
                        if (!(var8_2 instanceof Interpolatable[][])) break block3;
                        var5_4 = (Interpolatable[][])var8_2;
                        var3_5 /* !! */  = InterpolationUtils.interpolateArraySeriesPairwise((Interpolatable[][])var4_3, (Interpolatable[][])var5_4, (double)var1_1);
                        break block4;
                    }
                    if (!((var8_2 = this.startValue) instanceof Interpolatable[])) ** GOTO lbl-1000
                    var6_6 = (Interpolatable[])var8_2;
                    var8_2 = this.endValue;
                    if (var8_2 instanceof Interpolatable[]) {
                        var7_7 = (Interpolatable[])var8_2;
                        var3_5 /* !! */  = InterpolationUtils.interpolateArraysPairwise((Interpolatable[])var6_6, (Interpolatable[])var7_7, (double)var1_1);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var3_5 /* !! */  = this.startValue instanceof Interpolatable && this.endValue instanceof Interpolatable ? ((Interpolatable)this.startValue).interpolate(this.endValue, var1_1) : InterpolationUtils.interpolateDiscrete(this.startValue, this.endValue, var1_1);
                    }
                    break block4;
                }
                var3_5 /* !! */  = this.endValue;
            }
            this.associatedController.onUpdate(this.metadata, var3_5 /* !! */ );
        }

        @Override
        public void onStop() {
            this.associatedController.onStop(this);
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            ComponentTransitionMediator componentTransitionMediator = (ComponentTransitionMediator)transitionMediator;
            if (Objects.deepEquals(componentTransitionMediator.reversingAdjustedStartValue, this.endValue)) {
                this.reversingAdjustedStartValue = componentTransitionMediator.endValue;
                return true;
            }
            return false;
        }
    }
}

