/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;
import javafx.util.Duration;

public final class DurationConverter
extends StyleConverter<ParsedValue<?, Size>, Duration> {
    public static StyleConverter<ParsedValue<?, Size>, Duration> getInstance() {
        return Holder.INSTANCE;
    }

    private DurationConverter() {
    }

    @Override
    public Duration convert(ParsedValue<ParsedValue<?, Size>, Duration> parsedValue, Font font) {
        ParsedValue<?, Size> parsedValue2 = parsedValue.getValue();
        Size size = parsedValue2.convert(font);
        double d2 = size.getValue();
        Duration duration = null;
        if (d2 < Double.POSITIVE_INFINITY) {
            switch (size.getUnits()) {
                case S: {
                    duration = Duration.seconds(d2);
                    break;
                }
                case MS: {
                    duration = Duration.millis(d2);
                    break;
                }
                default: {
                    duration = Duration.UNKNOWN;
                    break;
                }
            }
        } else {
            duration = Duration.INDEFINITE;
        }
        return duration;
    }

    public String toString() {
        return "DurationConverter";
    }

    private static class Holder {
        static final DurationConverter INSTANCE = new DurationConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue<?, Size>, Duration>[], Duration[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Duration[] convert(ParsedValue<ParsedValue<ParsedValue<?, Size>, Duration>[], Duration[]> parsedValue, Font font) {
            ParsedValue<ParsedValue<?, Size>, Duration>[] parsedValueArray = parsedValue.getValue();
            Duration[] durationArray = new Duration[parsedValueArray.length];
            for (int i2 = 0; i2 < parsedValueArray.length; ++i2) {
                durationArray[i2] = parsedValueArray[i2].convert(font);
            }
            return durationArray;
        }

        public String toString() {
            return "Duration.SequenceConverter";
        }
    }
}

