/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

import com.sun.javafx.util.InterpolationUtils;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;

public class Insets
implements Interpolatable<Insets> {
    public static final Insets EMPTY = new Insets(0.0, 0.0, 0.0, 0.0);
    private double top;
    private double right;
    private double bottom;
    private double left;
    private int hash = 0;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public Insets(@NamedArg(value="top") double d2, @NamedArg(value="right") double d3, @NamedArg(value="bottom") double d4, @NamedArg(value="left") double d5) {
        this.top = d2;
        this.right = d3;
        this.bottom = d4;
        this.left = d5;
    }

    public Insets(@NamedArg(value="topRightBottomLeft") double d2) {
        this.top = d2;
        this.right = d2;
        this.bottom = d2;
        this.left = d2;
    }

    @Override
    public Insets interpolate(Insets insets, double d2) {
        Objects.requireNonNull(insets, "endValue cannot be null");
        if (d2 <= 0.0 || this.equals(insets)) {
            return this;
        }
        if (d2 >= 1.0) {
            return insets;
        }
        return new Insets(InterpolationUtils.interpolate(this.top, insets.top, d2), InterpolationUtils.interpolate(this.right, insets.right, d2), InterpolationUtils.interpolate(this.bottom, insets.bottom, d2), InterpolationUtils.interpolate(this.left, insets.left, d2));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Insets) {
            Insets insets = (Insets)object;
            return this.top == insets.top && this.right == insets.right && this.bottom == insets.bottom && this.left == insets.left;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l2 = 17L;
            l2 = 37L * l2 + Double.doubleToLongBits(this.top);
            l2 = 37L * l2 + Double.doubleToLongBits(this.right);
            l2 = 37L * l2 + Double.doubleToLongBits(this.bottom);
            l2 = 37L * l2 + Double.doubleToLongBits(this.left);
            this.hash = (int)(l2 ^ l2 >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Insets [top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + "]";
    }
}

