/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.TempState;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.PropertyHelper;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.stage.Window;

public abstract non-sealed class Parent
extends Node {
    static final int DIRTY_CHILDREN_THRESHOLD = 10;
    private static final boolean warnOnAutoMove = PropertyHelper.getBooleanProperty("javafx.sg.warn");
    private static final int REMOVED_CHILDREN_THRESHOLD = 20;
    private boolean removedChildrenOptimizationDisabled = false;
    private final Set<Node> childSet = new HashSet<Node>();
    private int startIdx = 0;
    private int pgChildrenSize = 0;
    private final List<Node> viewOrderChildren = new ArrayList<Node>(1);
    private boolean childrenTriggerPermutation = false;
    private List<Node> removed;
    private boolean geomChanged;
    private boolean childSetModified;
    private final ObservableList<Node> children = new VetoableListDecorator<Node>((ObservableList)new TrackableObservableList<Node>(){
        private static final PseudoClass FIRST_CHILD_PSEUDO_CLASS = PseudoClass.getPseudoClass("first-child");
        private static final PseudoClass LAST_CHILD_PSEUDO_CLASS = PseudoClass.getPseudoClass("last-child");
        private static final PseudoClass ONLY_CHILD_PSEUDO_CLASS = PseudoClass.getPseudoClass("only-child");
        private static final PseudoClass NTH_EVEN_CHILD_PSEUDO_CLASS = PseudoClass.getPseudoClass("nth-child(even)");
        private static final PseudoClass NTH_ODD_CHILD_PSEUDO_CLASS = PseudoClass.getPseudoClass("nth-child(odd)");

        @Override
        protected void onChanged(ListChangeListener.Change<Node> change) {
            int n2;
            boolean bl;
            boolean bl2;
            block22: {
                Parent.this.unmodifiableManagedChildren = null;
                bl2 = false;
                bl = false;
                n2 = -1;
                if (Parent.this.childSetModified) {
                    Object object;
                    int n3;
                    int n4;
                    while (change.next()) {
                        Node node;
                        int n5;
                        n4 = change.getFrom();
                        n3 = change.getTo();
                        for (int i2 = n4; i2 < n3; ++i2) {
                            Node node2 = (Node)Parent.this.children.get(i2);
                            if (node2.getParent() == null || node2.getParent() == Parent.this) continue;
                            if (warnOnAutoMove) {
                                System.err.println("WARNING added to a new parent without first removing it from its current");
                                System.err.println("    parent. It will be automatically removed from its current parent.");
                                System.err.println("    node=" + String.valueOf(node2) + " oldparent= " + String.valueOf(node2.getParent()) + " newparent=" + String.valueOf(this));
                            }
                            node2.getParent().children.remove(node2);
                            if (!warnOnAutoMove) continue;
                            Thread.dumpStack();
                        }
                        object = change.getRemoved();
                        int n6 = object.size();
                        for (n5 = 0; n5 < n6; ++n5) {
                            node = object.get(n5);
                            if (!node.isManaged()) continue;
                            bl2 = true;
                        }
                        if (n2 < 0) {
                            n2 = n4;
                        }
                        if (!(n6 <= 0 && n3 - n4 <= 0 || Parent.this.viewOrderChildren.isEmpty())) {
                            bl = true;
                        }
                        for (n5 = n4; n5 < n3; ++n5) {
                            node = (Node)Parent.this.children.get(n5);
                            if (node.getViewOrder() != 0.0) {
                                bl = true;
                            }
                            if (node.isManaged() || node instanceof Parent && ((Parent)node).layoutFlag != LayoutFlags.CLEAN) {
                                bl2 = true;
                            }
                            node.setParent(Parent.this);
                            node.setScenes(Parent.this.getScene(), Parent.this.getSubScene());
                            if (!node.isVisible()) continue;
                            Parent.this.geomChanged = true;
                            Parent.this.childIncluded(node);
                        }
                    }
                    if (Parent.this.dirtyChildren == null && Parent.this.children.size() > 10) {
                        Parent.this.dirtyChildren = new ArrayList(20);
                        if (Parent.this.dirtyChildrenCount > 0) {
                            n4 = Parent.this.children.size();
                            for (n3 = 0; n3 < n4; ++n3) {
                                object = (Node)Parent.this.children.get(n3);
                                if (!((Node)object).isVisible() || !((Node)object).boundsChanged) continue;
                                Parent.this.dirtyChildren.add((Node)object);
                            }
                        }
                    }
                } else {
                    while (change.next()) {
                        int n7;
                        if (n2 < 0) {
                            n2 = change.getFrom();
                        }
                        List<Node> list = change.getRemoved();
                        int n8 = list.size();
                        for (n7 = 0; n7 < n8; ++n7) {
                            if (!list.get(n7).isManaged()) continue;
                            bl2 = true;
                            break block22;
                        }
                        n8 = change.getTo();
                        for (n7 = change.getFrom(); n7 < n8; ++n7) {
                            if (!((Node)Parent.this.children.get(n7)).isManaged()) continue;
                            bl2 = true;
                            break block22;
                        }
                    }
                }
            }
            if (bl2) {
                Parent.this.requestLayout();
            }
            if (Parent.this.geomChanged) {
                NodeHelper.geomChanged(Parent.this);
            }
            if (Parent.this.startIdx > n2) {
                Parent.this.startIdx = n2;
            }
            NodeHelper.markDirty(Parent.this, DirtyBits.PARENT_CHILDREN);
            NodeHelper.markDirty(Parent.this, DirtyBits.NODE_FORCE_SYNC);
            if (bl) {
                Parent.this.markViewOrderChildrenDirty();
            }
            change.reset();
            this.updateStructuralPseudoClasses(change, n2);
        }

        private void updateStructuralPseudoClasses(ListChangeListener.Change<Node> change, int n2) {
            Node node;
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (Node node2 : change.getRemoved()) {
                    node2.pseudoClassStateChanged(FIRST_CHILD_PSEUDO_CLASS, false);
                    node2.pseudoClassStateChanged(LAST_CHILD_PSEUDO_CLASS, false);
                    node2.pseudoClassStateChanged(ONLY_CHILD_PSEUDO_CLASS, false);
                    node2.pseudoClassStateChanged(NTH_EVEN_CHILD_PSEUDO_CLASS, false);
                    node2.pseudoClassStateChanged(NTH_ODD_CHILD_PSEUDO_CLASS, false);
                }
            }
            int n3 = this.size();
            if (n3 == 1) {
                node2 = (Node)this.getFirst();
                node2.pseudoClassStateChanged(FIRST_CHILD_PSEUDO_CLASS, true);
                node2.pseudoClassStateChanged(LAST_CHILD_PSEUDO_CLASS, true);
                node2.pseudoClassStateChanged(ONLY_CHILD_PSEUDO_CLASS, true);
            } else if (n3 > 1) {
                Node node3;
                node2 = (Node)this.getFirst();
                node = (Node)this.getLast();
                node2.pseudoClassStateChanged(FIRST_CHILD_PSEUDO_CLASS, true);
                node2.pseudoClassStateChanged(LAST_CHILD_PSEUDO_CLASS, false);
                node2.pseudoClassStateChanged(ONLY_CHILD_PSEUDO_CLASS, false);
                node.pseudoClassStateChanged(LAST_CHILD_PSEUDO_CLASS, true);
                if (n2 > 0 && node != (node3 = (Node)this.get(n2 - 1))) {
                    node3.pseudoClassStateChanged(LAST_CHILD_PSEUDO_CLASS, false);
                }
            }
            if (n2 >= 0) {
                for (int i2 = n2; i2 < n3; ++i2) {
                    node = (Node)this.get(i2);
                    node.pseudoClassStateChanged(NTH_EVEN_CHILD_PSEUDO_CLASS, i2 % 2 != 0);
                    node.pseudoClassStateChanged(NTH_ODD_CHILD_PSEUDO_CLASS, i2 % 2 == 0);
                }
            }
        }
    }){

        @Override
        protected void onProposedChange(List<Node> list, int ... nArray) {
            Node node;
            int n2;
            Window window;
            Scene scene = Parent.this.getScene();
            if (scene != null && (window = scene.getWindow()) != null && WindowHelper.getPeer(window) != null) {
                Toolkit.getToolkit().checkFxUserThread();
            }
            Parent.this.geomChanged = false;
            long l2 = Parent.this.children.size() + list.size();
            int n3 = 0;
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                n3 += nArray[n2 + 1] - nArray[n2];
            }
            l2 -= (long)n3;
            if (Parent.this.childrenTriggerPermutation) {
                Parent.this.childSetModified = false;
                return;
            }
            Parent.this.childSetModified = true;
            if (l2 == (long)Parent.this.childSet.size()) {
                Parent.this.childSetModified = false;
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    node = list.get(n2);
                    if (Parent.this.childSet.contains(node)) continue;
                    Parent.this.childSetModified = true;
                    break;
                }
            }
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                for (int i2 = nArray[n2]; i2 < nArray[n2 + 1]; ++i2) {
                    Parent.this.childSet.remove(Parent.this.children.get(i2));
                }
            }
            try {
                if (Parent.this.childSetModified) {
                    for (n2 = list.size() - 1; n2 >= 0; --n2) {
                        node = list.get(n2);
                        if (node == null) {
                            throw new NullPointerException(this.constructExceptionMessage("child node is null", null));
                        }
                        if (node.getClipParent() != null) {
                            throw new IllegalArgumentException(this.constructExceptionMessage("node already used as a clip", node));
                        }
                        if (!Parent.this.wouldCreateCycle(Parent.this, node)) continue;
                        throw new IllegalArgumentException(this.constructExceptionMessage("cycle detected", node));
                    }
                }
                Parent.this.childSet.addAll(list);
                if ((long)Parent.this.childSet.size() != l2) {
                    throw new IllegalArgumentException(this.constructExceptionMessage("duplicate children added", null));
                }
            }
            catch (RuntimeException runtimeException) {
                Parent.this.childSet.clear();
                Parent.this.childSet.addAll(Parent.this.children);
                throw runtimeException;
            }
            if (!Parent.this.childSetModified) {
                return;
            }
            if (Parent.this.removed == null) {
                Parent.this.removed = new ArrayList<Node>();
            }
            if (Parent.this.removed.size() + n3 > 20 || !Parent.this.isTreeVisible()) {
                Parent.this.removedChildrenOptimizationDisabled = true;
            }
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                for (int i3 = nArray[n2]; i3 < nArray[n2 + 1]; ++i3) {
                    Node node2 = (Node)Parent.this.children.get(i3);
                    Scene scene2 = node2.getScene();
                    if (scene2 != null) {
                        scene2.generateMouseExited(node2);
                    }
                    if (Parent.this.dirtyChildren != null) {
                        Parent.this.dirtyChildren.remove(node2);
                    }
                    if (node2.isVisible()) {
                        Parent.this.geomChanged = true;
                        Parent.this.childExcluded(node2);
                    }
                    if (node2.getParent() == Parent.this) {
                        node2.setParent(null);
                        node2.setScenes(null, null);
                    }
                    if (scene == null || Parent.this.removedChildrenOptimizationDisabled) continue;
                    Parent.this.removed.add(node2);
                }
            }
        }

        private String constructExceptionMessage(String string, Node node) {
            StringBuilder stringBuilder = new StringBuilder("Children: ");
            stringBuilder.append(string);
            stringBuilder.append(": parent = ").append(Parent.this);
            if (node != null) {
                stringBuilder.append(", node = ").append(node);
            }
            return stringBuilder.toString();
        }
    };
    private final ObservableList<Node> unmodifiableChildren = FXCollections.unmodifiableObservableList(this.children);
    private List<Node> unmodifiableManagedChildren = null;
    private ParentTraversalEngine traversalEngine;
    private ReadOnlyBooleanWrapper needsLayout;
    LayoutFlags layoutFlag = LayoutFlags.CLEAN;
    private boolean performingLayout = false;
    private boolean sizeCacheClear = true;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private boolean forceParentLayout = false;
    private Node currentLayoutChild = null;
    private boolean sceneRoot = false;
    boolean layoutRoot = false;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            Scene scene = Parent.this.getScene();
            if (scene != null) {
                StyleManager.getInstance().stylesheetsChanged(Parent.this, change);
                change.reset();
                while (change.next() && !change.wasRemoved()) {
                }
                Parent.this.reapplyCSS();
            }
        }
    };
    private BaseBounds tmp;
    private BaseBounds cachedBounds;
    private boolean cachedBoundsInvalid;
    private int dirtyChildrenCount;
    private ArrayList<Node> dirtyChildren;
    private Node top;
    private Node left;
    private Node bottom;
    private Node right;
    private Node near;
    private Node far;
    private static final int LEFT_INVALID = 1;
    private static final int TOP_INVALID = 2;
    private static final int NEAR_INVALID = 4;
    private static final int RIGHT_INVALID = 8;
    private static final int BOTTOM_INVALID = 16;
    private static final int FAR_INVALID = 32;
    private Node currentlyProcessedChild;

    private void doUpdatePeer() {
        List<NGNode> list;
        NGGroup nGGroup = (NGGroup)this.getPeer();
        if (Utils.assertionEnabled() && (list = nGGroup.getChildren()).size() != this.pgChildrenSize) {
            System.err.println("*** pgnodes.size() [" + list.size() + "] != pgChildrenSize [" + this.pgChildrenSize + "]");
        }
        if (this.isDirty(DirtyBits.PARENT_CHILDREN)) {
            int n2;
            nGGroup.clearFrom(this.startIdx);
            for (n2 = this.startIdx; n2 < this.children.size(); ++n2) {
                nGGroup.add(n2, (NGNode)((Node)this.children.get(n2)).getPeer());
            }
            if (this.removedChildrenOptimizationDisabled) {
                nGGroup.markDirty();
                this.removedChildrenOptimizationDisabled = false;
            } else if (this.removed != null && !this.removed.isEmpty()) {
                for (n2 = 0; n2 < this.removed.size(); ++n2) {
                    nGGroup.addToRemoved((NGNode)this.removed.get(n2).getPeer());
                }
            }
            if (this.removed != null) {
                this.removed.clear();
            }
            this.startIdx = this.pgChildrenSize = this.children.size();
        }
        if (this.isDirty(DirtyBits.PARENT_CHILDREN_VIEW_ORDER)) {
            this.computeViewOrderChildren();
            nGGroup.setViewOrderChildren(this.viewOrderChildren);
        }
        if (Utils.assertionEnabled()) {
            this.validatePG();
        }
    }

    void validatePG() {
        boolean bl = false;
        NGGroup nGGroup = (NGGroup)this.getPeer();
        List<NGNode> list = nGGroup.getChildren();
        if (list.size() != this.children.size()) {
            System.err.println("*** pgnodes.size validatePG() [" + list.size() + "] != children.size() [" + this.children.size() + "]");
            bl = true;
        } else {
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                Node node = (Node)this.children.get(i2);
                if (node.getParent() != this) {
                    System.err.println("*** this=" + String.valueOf(this) + " validatePG children[" + i2 + "].parent= " + String.valueOf(node.getParent()));
                    bl = true;
                }
                if (node.getPeer() == list.get(i2)) continue;
                System.err.println("*** pgnodes[" + i2 + "] validatePG != children[" + i2 + "]");
                bl = true;
            }
        }
        if (bl) {
            throw new AssertionError((Object)"validation of PGGroup children failed");
        }
    }

    void printSeq(String string, List<Node> list) {
        Object object = string;
        for (Node node : list) {
            object = (String)object + String.valueOf(node) + " ";
        }
        System.out.println((String)object);
    }

    void markViewOrderChildrenDirty() {
        this.viewOrderChildren.clear();
        NodeHelper.markDirty(this, DirtyBits.PARENT_CHILDREN_VIEW_ORDER);
    }

    private void computeViewOrderChildren() {
        boolean bl = false;
        for (Node node3 : this.children) {
            double d2 = node3.getViewOrder();
            if (bl || d2 == 0.0) continue;
            bl = true;
        }
        this.viewOrderChildren.clear();
        if (bl) {
            this.viewOrderChildren.addAll(this.children);
            Collections.sort(this.viewOrderChildren, (node, node2) -> node.getViewOrder() < node2.getViewOrder() ? 1 : (node.getViewOrder() == node2.getViewOrder() ? 0 : -1));
        }
    }

    private List<Node> getOrderedChildren() {
        if (this.isDirty(DirtyBits.PARENT_CHILDREN_VIEW_ORDER)) {
            this.computeViewOrderChildren();
        }
        if (!this.viewOrderChildren.isEmpty()) {
            return this.viewOrderChildren;
        }
        return this.children;
    }

    protected ObservableList<Node> getChildren() {
        return this.children;
    }

    public ObservableList<Node> getChildrenUnmodifiable() {
        return this.unmodifiableChildren;
    }

    protected <E extends Node> List<E> getManagedChildren() {
        if (this.unmodifiableManagedChildren == null) {
            this.unmodifiableManagedChildren = new ArrayList<Node>();
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)this.children.get(i2);
                if (!node.isManaged()) continue;
                this.unmodifiableManagedChildren.add(node);
            }
        }
        return this.unmodifiableManagedChildren;
    }

    final void managedChildChanged() {
        this.requestLayout();
        this.unmodifiableManagedChildren = null;
    }

    final void toFront(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(this.children.size() - 1) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    final void toBack(Node node) {
        if (Utils.assertionEnabled() && !this.childSet.contains(node)) {
            throw new AssertionError((Object)"specified node is not in the list of children");
        }
        if (this.children.get(0) != node) {
            this.childrenTriggerPermutation = true;
            try {
                this.children.remove(node);
                this.children.add(0, node);
            }
            finally {
                this.childrenTriggerPermutation = false;
            }
        }
    }

    @Override
    void scenesChanged(Scene scene, SubScene subScene, Scene scene2, SubScene subScene2) {
        int n2;
        if (scene2 != null && scene == null) {
            StyleManager.getInstance().forget(this);
            if (this.removed != null) {
                this.removed.clear();
            }
        }
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            ((Node)this.children.get(n2)).setScenes(scene, subScene);
        }
        n2 = this.layoutFlag != LayoutFlags.CLEAN ? 1 : 0;
        this.sceneRoot = subScene != null && subScene.getRoot() == this || scene != null && scene.getRoot() == this;
        boolean bl = this.layoutRoot = !this.isManaged() || this.sceneRoot;
        if (n2 != 0 && scene != null && this.layoutRoot && subScene != null) {
            subScene.setDirtyLayout(this);
        }
    }

    @Override
    void setDerivedDepthTest(boolean bl) {
        super.setDerivedDepthTest(bl);
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            node.computeDerivedDepthTest();
        }
    }

    boolean pickChildrenNode(PickRay pickRay, PickResultChooser pickResultChooser) {
        List<Node> list = this.getOrderedChildren();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            list.get(i2).pickNode(pickRay, pickResultChooser);
            if (!pickResultChooser.isClosed()) continue;
            return false;
        }
        return true;
    }

    private void doPickNodeLocal(PickRay pickRay, PickResultChooser pickResultChooser) {
        double d2 = this.intersectsBounds(pickRay);
        if (!Double.isNaN(d2) && this.pickChildrenNode(pickRay, pickResultChooser) && this.isPickOnBounds()) {
            pickResultChooser.offer(this, d2, PickResultChooser.computePoint(pickRay, d2));
        }
    }

    @Override
    boolean isConnected() {
        return super.isConnected() || this.sceneRoot;
    }

    @Override
    public Node lookup(String string) {
        Node node = super.lookup(string);
        if (node == null) {
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node2 = (Node)this.children.get(i2);
                node = node2.lookup(string);
                if (node == null) continue;
                return node;
            }
        }
        return node;
    }

    @Override
    List<Node> lookupAll(Selector selector, List<Node> list) {
        list = super.lookupAll(selector, list);
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            list = node.lookupAll(selector, list);
        }
        return list;
    }

    private final void setTraversalEngine(ParentTraversalEngine parentTraversalEngine) {
        this.traversalEngine = parentTraversalEngine;
    }

    private final ParentTraversalEngine getTraversalEngine() {
        return this.traversalEngine;
    }

    protected final void setNeedsLayout(boolean bl) {
        if (bl) {
            this.markDirtyLayout(true, false);
        } else if (this.layoutFlag == LayoutFlags.NEEDS_LAYOUT) {
            boolean bl2 = false;
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = (Node)this.children.get(i2);
                if (!(node instanceof Parent) || ((Parent)node).layoutFlag == LayoutFlags.CLEAN) continue;
                bl2 = true;
                break;
            }
            this.setLayoutFlag(bl2 ? LayoutFlags.DIRTY_BRANCH : LayoutFlags.CLEAN);
        }
    }

    public final boolean isNeedsLayout() {
        return this.layoutFlag == LayoutFlags.NEEDS_LAYOUT;
    }

    public final ReadOnlyBooleanProperty needsLayoutProperty() {
        if (this.needsLayout == null) {
            this.needsLayout = new ReadOnlyBooleanWrapper(this, "needsLayout", this.layoutFlag == LayoutFlags.NEEDS_LAYOUT);
        }
        return this.needsLayout;
    }

    boolean isPerformingLayout() {
        return this.performingLayout;
    }

    void setLayoutFlag(LayoutFlags layoutFlags) {
        if (this.needsLayout != null) {
            this.needsLayout.set(layoutFlags == LayoutFlags.NEEDS_LAYOUT);
        }
        this.layoutFlag = layoutFlags;
    }

    private void markDirtyLayout(boolean bl, boolean bl2) {
        this.setLayoutFlag(LayoutFlags.NEEDS_LAYOUT);
        if (bl || this.layoutRoot) {
            if (this.sceneRoot) {
                Toolkit.getToolkit().requestNextPulse();
                if (this.getSubScene() != null) {
                    this.getSubScene().setDirtyLayout(this);
                }
            } else {
                this.markDirtyLayoutBranch();
            }
        } else {
            this.requestParentLayout(bl2);
        }
    }

    public void requestLayout() {
        this.clearSizeCache();
        this.markDirtyLayout(false, this.forceParentLayout);
    }

    void requestLayout(boolean bl) {
        boolean bl2 = this.forceParentLayout;
        this.forceParentLayout = bl;
        this.requestLayout();
        this.forceParentLayout = bl2;
    }

    protected final void requestParentLayout() {
        this.requestParentLayout(false);
    }

    void requestParentLayout(boolean bl) {
        Parent parent;
        if (!(this.layoutRoot || (parent = this.getParent()) == null || parent.performingLayout && !bl)) {
            parent.requestLayout();
        }
    }

    void clearSizeCache() {
        if (this.sizeCacheClear) {
            return;
        }
        this.sizeCacheClear = true;
        this.prefWidthCache = -1.0;
        this.prefHeightCache = -1.0;
        this.minWidthCache = -1.0;
        this.minHeightCache = -1.0;
    }

    @Override
    public double prefWidth(double d2) {
        if (d2 == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.computePrefWidth(-1.0);
                if (Double.isNaN(this.prefWidthCache) || this.prefWidthCache < 0.0) {
                    this.prefWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefWidthCache;
        }
        double d3 = this.computePrefWidth(d2);
        return Double.isNaN(d3) || d3 < 0.0 ? 0.0 : d3;
    }

    @Override
    public double prefHeight(double d2) {
        if (d2 == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.computePrefHeight(-1.0);
                if (Double.isNaN(this.prefHeightCache) || this.prefHeightCache < 0.0) {
                    this.prefHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.prefHeightCache;
        }
        double d3 = this.computePrefHeight(d2);
        return Double.isNaN(d3) || d3 < 0.0 ? 0.0 : d3;
    }

    @Override
    public double minWidth(double d2) {
        if (d2 == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.computeMinWidth(-1.0);
                if (Double.isNaN(this.minWidthCache) || this.minWidthCache < 0.0) {
                    this.minWidthCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minWidthCache;
        }
        double d3 = this.computeMinWidth(d2);
        return Double.isNaN(d3) || d3 < 0.0 ? 0.0 : d3;
    }

    @Override
    public double minHeight(double d2) {
        if (d2 == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.computeMinHeight(-1.0);
                if (Double.isNaN(this.minHeightCache) || this.minHeightCache < 0.0) {
                    this.minHeightCache = 0.0;
                }
                this.sizeCacheClear = false;
            }
            return this.minHeightCache;
        }
        double d3 = this.computeMinHeight(d2);
        return Double.isNaN(d3) || d3 < 0.0 ? 0.0 : d3;
    }

    protected double computePrefWidth(double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isManaged()) continue;
            double d5 = node.getLayoutBounds().getMinX() + node.getLayoutX();
            d3 = Math.min(d3, d5);
            d4 = Math.max(d4, d5 + this.boundedSize(node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d4 - d3;
    }

    protected double computePrefHeight(double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isManaged()) continue;
            double d5 = node.getLayoutBounds().getMinY() + node.getLayoutY();
            d3 = Math.min(d3, d5);
            d4 = Math.max(d4, d5 + this.boundedSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d4 - d3;
    }

    protected double computeMinWidth(double d2) {
        return this.prefWidth(d2);
    }

    protected double computeMinHeight(double d2) {
        return this.prefHeight(d2);
    }

    @Override
    public double getBaselineOffset() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            Node node = (Node)this.children.get(i2);
            if (!node.isManaged() || (d2 = node.getBaselineOffset()) == Double.NEGATIVE_INFINITY) continue;
            return node.getLayoutBounds().getMinY() + node.getLayoutY() + d2;
        }
        return super.getBaselineOffset();
    }

    boolean isCurrentLayoutChild(Node node) {
        return node == this.currentLayoutChild;
    }

    public final void layout() {
        LayoutFlags layoutFlags = this.layoutFlag;
        this.setLayoutFlag(LayoutFlags.CLEAN);
        switch (layoutFlags) {
            case CLEAN: {
                break;
            }
            case NEEDS_LAYOUT: {
                if (this.performingLayout) break;
                this.performingLayout = true;
                this.layoutChildren();
            }
            case DIRTY_BRANCH: {
                int n2 = this.children.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node node;
                    this.currentLayoutChild = node = (Node)this.children.get(i2);
                    if (node instanceof Parent) {
                        ((Parent)node).layout();
                        continue;
                    }
                    if (!(node instanceof SubScene)) continue;
                    ((SubScene)node).layoutPass();
                }
                this.currentLayoutChild = null;
                this.performingLayout = false;
            }
        }
    }

    protected void layoutChildren() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node;
            this.currentLayoutChild = node = (Node)this.children.get(i2);
            if (!node.isResizable() || !node.isManaged()) continue;
            node.autosize();
        }
        this.currentLayoutChild = null;
    }

    @Override
    final void notifyManagedChanged() {
        this.layoutRoot = !this.isManaged() || this.sceneRoot;
    }

    final boolean isSceneRoot() {
        return this.sceneRoot;
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    private List<String> doGetAllParentStylesheets() {
        List<String> list = null;
        Parent parent = this.getParent();
        if (parent != null) {
            list = ParentHelper.getAllParentStylesheets(parent);
        }
        if (this.stylesheets != null && !this.stylesheets.isEmpty()) {
            if (list == null) {
                list = new ArrayList<String>(this.stylesheets.size());
            }
            int n2 = this.stylesheets.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                list.add((String)this.stylesheets.get(i2));
            }
        }
        return list;
    }

    private void doProcessCSS() {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.cssFlag == CssFlags.DIRTY_BRANCH) {
            super.processCSS();
            return;
        }
        ParentHelper.superProcessCSS(this);
        if (this.children.isEmpty()) {
            return;
        }
        Node[] nodeArray = this.children.toArray(new Node[this.children.size()]);
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            Node node = nodeArray[i2];
            Parent parent = node.getParent();
            if (parent == null || parent != this) continue;
            if (CssFlags.UPDATE.compareTo(node.cssFlag) > 0) {
                node.cssFlag = CssFlags.UPDATE;
            }
            NodeHelper.processCSS(node);
        }
    }

    protected Parent() {
        ParentHelper.initHelper(this);
        this.tmp = new RectBounds();
        this.cachedBounds = new RectBounds();
        this.layoutFlag = LayoutFlags.NEEDS_LAYOUT;
        this.setAccessibleRole(AccessibleRole.PARENT);
    }

    private NGNode doCreatePeer() {
        return new NGGroup();
    }

    @Override
    void nodeResolvedOrientationChanged() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.children.get(i2)).parentResolvedOrientationInvalidated();
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.children.isEmpty()) {
            return baseBounds.makeEmpty();
        }
        if (baseTransform.isTranslateOrIdentity()) {
            if (this.cachedBoundsInvalid) {
                this.recomputeBounds();
                if (this.dirtyChildren != null) {
                    this.dirtyChildren.clear();
                }
                this.cachedBoundsInvalid = false;
                this.dirtyChildrenCount = 0;
            }
            baseBounds = !baseTransform.isIdentity() ? baseBounds.deriveWithNewBounds((float)((double)this.cachedBounds.getMinX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMinY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMinZ() + baseTransform.getMzt()), (float)((double)this.cachedBounds.getMaxX() + baseTransform.getMxt()), (float)((double)this.cachedBounds.getMaxY() + baseTransform.getMyt()), (float)((double)this.cachedBounds.getMaxZ() + baseTransform.getMzt())) : baseBounds.deriveWithNewBounds(this.cachedBounds);
            return baseBounds;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        double d6 = Double.MIN_VALUE;
        double d7 = Double.MIN_VALUE;
        boolean bl = true;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            if (!node.isVisible() || (baseBounds = this.getChildTransformedBounds(node, baseTransform, baseBounds)).isEmpty()) continue;
            if (bl) {
                d2 = baseBounds.getMinX();
                d3 = baseBounds.getMinY();
                d4 = baseBounds.getMinZ();
                d5 = baseBounds.getMaxX();
                d6 = baseBounds.getMaxY();
                d7 = baseBounds.getMaxZ();
                bl = false;
                continue;
            }
            d2 = Math.min((double)baseBounds.getMinX(), d2);
            d3 = Math.min((double)baseBounds.getMinY(), d3);
            d4 = Math.min((double)baseBounds.getMinZ(), d4);
            d5 = Math.max((double)baseBounds.getMaxX(), d5);
            d6 = Math.max((double)baseBounds.getMaxY(), d6);
            d7 = Math.max((double)baseBounds.getMaxZ(), d7);
        }
        if (bl) {
            baseBounds.makeEmpty();
        } else {
            baseBounds = baseBounds.deriveWithNewBounds((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7);
        }
        return baseBounds;
    }

    private void setChildDirty(Node node, boolean bl) {
        if (node.boundsChanged == bl) {
            return;
        }
        node.boundsChanged = bl;
        if (bl) {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.add(node);
            }
            ++this.dirtyChildrenCount;
        } else {
            if (this.dirtyChildren != null) {
                this.dirtyChildren.remove(node);
            }
            --this.dirtyChildrenCount;
        }
    }

    private void childIncluded(Node node) {
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
    }

    private void childExcluded(Node node) {
        if (node == this.left) {
            this.left = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.top) {
            this.top = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.near) {
            this.near = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.right) {
            this.right = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.bottom) {
            this.bottom = null;
            this.cachedBoundsInvalid = true;
        }
        if (node == this.far) {
            this.far = null;
            this.cachedBoundsInvalid = true;
        }
        this.setChildDirty(node, false);
    }

    private void recomputeBounds() {
        if (this.children.isEmpty()) {
            this.cachedBounds.makeEmpty();
            return;
        }
        if (this.children.size() == 1) {
            Node node = (Node)this.children.get(0);
            node.boundsChanged = false;
            if (node.isVisible()) {
                this.cachedBounds = this.getChildTransformedBounds(node, BaseTransform.IDENTITY_TRANSFORM, this.cachedBounds);
                this.near = this.far = node;
                this.right = this.far;
                this.bottom = this.far;
                this.left = this.far;
                this.top = this.far;
            } else {
                this.cachedBounds.makeEmpty();
            }
            return;
        }
        if (this.dirtyChildrenCount == 0 || !this.updateCachedBounds(this.dirtyChildren != null ? this.dirtyChildren : this.children, this.dirtyChildrenCount)) {
            this.createCachedBounds(this.children);
        }
    }

    private boolean updateCachedBounds(List<Node> list, int n2) {
        if (this.cachedBounds.isEmpty()) {
            this.createCachedBounds(list);
            return true;
        }
        int n3 = 0;
        if (this.left == null || this.left.boundsChanged) {
            n3 |= 1;
        }
        if (this.top == null || this.top.boundsChanged) {
            n3 |= 2;
        }
        if (this.near == null || this.near.boundsChanged) {
            n3 |= 4;
        }
        if (this.right == null || this.right.boundsChanged) {
            n3 |= 8;
        }
        if (this.bottom == null || this.bottom.boundsChanged) {
            n3 |= 0x10;
        }
        if (this.far == null || this.far.boundsChanged) {
            n3 |= 0x20;
        }
        float f2 = this.cachedBounds.getMinX();
        float f3 = this.cachedBounds.getMinY();
        float f4 = this.cachedBounds.getMinZ();
        float f5 = this.cachedBounds.getMaxX();
        float f6 = this.cachedBounds.getMaxY();
        float f7 = this.cachedBounds.getMaxZ();
        int n4 = list.size() - 1;
        while (n2 > 0) {
            Node node = list.get(n4);
            if (node.boundsChanged) {
                node.boundsChanged = false;
                --n2;
                this.tmp = this.getChildTransformedBounds(node, BaseTransform.IDENTITY_TRANSFORM, this.tmp);
                if (!this.tmp.isEmpty()) {
                    float f8 = this.tmp.getMinX();
                    float f9 = this.tmp.getMinY();
                    float f10 = this.tmp.getMinZ();
                    float f11 = this.tmp.getMaxX();
                    float f12 = this.tmp.getMaxY();
                    float f13 = this.tmp.getMaxZ();
                    if (f8 <= f2) {
                        f2 = f8;
                        this.left = node;
                        n3 &= 0xFFFFFFFE;
                    }
                    if (f9 <= f3) {
                        f3 = f9;
                        this.top = node;
                        n3 &= 0xFFFFFFFD;
                    }
                    if (f10 <= f4) {
                        f4 = f10;
                        this.near = node;
                        n3 &= 0xFFFFFFFB;
                    }
                    if (f11 >= f5) {
                        f5 = f11;
                        this.right = node;
                        n3 &= 0xFFFFFFF7;
                    }
                    if (f12 >= f6) {
                        f6 = f12;
                        this.bottom = node;
                        n3 &= 0xFFFFFFEF;
                    }
                    if (f13 >= f7) {
                        f7 = f13;
                        this.far = node;
                        n3 &= 0xFFFFFFDF;
                    }
                }
            }
            --n4;
        }
        if (n3 != 0) {
            return false;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(f2, f3, f4, f5, f6, f7);
        return true;
    }

    private void createCachedBounds(List<Node> list) {
        Node node;
        int n2;
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            node = list.get(n2);
            node.boundsChanged = false;
            if (!node.isVisible()) continue;
            this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
            if (this.tmp.isEmpty()) continue;
            this.bottom = this.far = node;
            this.right = this.far;
            this.near = this.far;
            this.top = this.far;
            this.left = this.far;
            break;
        }
        if (n2 == n3) {
            this.far = null;
            this.bottom = null;
            this.right = null;
            this.near = null;
            this.top = null;
            this.left = null;
            this.cachedBounds.makeEmpty();
            return;
        }
        float f2 = this.tmp.getMinX();
        float f3 = this.tmp.getMinY();
        float f4 = this.tmp.getMinZ();
        float f5 = this.tmp.getMaxX();
        float f6 = this.tmp.getMaxY();
        float f7 = this.tmp.getMaxZ();
        ++n2;
        while (n2 < n3) {
            node = list.get(n2);
            node.boundsChanged = false;
            if (node.isVisible()) {
                this.tmp = node.getTransformedBounds(this.tmp, BaseTransform.IDENTITY_TRANSFORM);
                if (!this.tmp.isEmpty()) {
                    float f8 = this.tmp.getMinX();
                    float f9 = this.tmp.getMinY();
                    float f10 = this.tmp.getMinZ();
                    float f11 = this.tmp.getMaxX();
                    float f12 = this.tmp.getMaxY();
                    float f13 = this.tmp.getMaxZ();
                    if (f8 < f2) {
                        f2 = f8;
                        this.left = node;
                    }
                    if (f9 < f3) {
                        f3 = f9;
                        this.top = node;
                    }
                    if (f10 < f4) {
                        f4 = f10;
                        this.near = node;
                    }
                    if (f11 > f5) {
                        f5 = f11;
                        this.right = node;
                    }
                    if (f12 > f6) {
                        f6 = f12;
                        this.bottom = node;
                    }
                    if (f13 > f7) {
                        f7 = f13;
                        this.far = node;
                    }
                }
            }
            ++n2;
        }
        this.cachedBounds = this.cachedBounds.deriveWithNewBounds(f2, f3, f4, f5, f6, f7);
    }

    @Override
    protected void updateBounds() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Node)this.children.get(i2)).updateBounds();
        }
        super.updateBounds();
    }

    private BaseBounds getChildTransformedBounds(Node node, BaseTransform baseTransform, BaseBounds baseBounds) {
        this.currentlyProcessedChild = node;
        baseBounds = node.getTransformedBounds(baseBounds, baseTransform);
        this.currentlyProcessedChild = null;
        return baseBounds;
    }

    void childBoundsChanged(Node node) {
        if (node == this.currentlyProcessedChild) {
            return;
        }
        this.cachedBoundsInvalid = true;
        this.setChildDirty(node, true);
        NodeHelper.geomChanged(this);
    }

    void childVisibilityChanged(Node node) {
        if (node.isVisible()) {
            this.childIncluded(node);
        } else {
            this.childExcluded(node);
        }
        NodeHelper.geomChanged(this);
    }

    private boolean doComputeContains(double d2, double d3) {
        Point2D point2D = TempState.getInstance().point;
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            point2D.x = (float)d2;
            point2D.y = (float)d3;
            try {
                node.parentToLocal(point2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                continue;
            }
            if (!node.contains(point2D.x, point2D.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case CHILDREN: {
                return this.getChildrenUnmodifiable();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    void releaseAccessible() {
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)this.children.get(i2);
            node.releaseAccessible();
        }
        super.releaseAccessible();
    }

    List<Node> test_getRemoved() {
        return this.removed;
    }

    List<Node> test_getViewOrderChildren() {
        return this.viewOrderChildren;
    }

    static {
        ParentHelper.setParentAccessor(new ParentHelper.ParentAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Parent)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Parent)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds baseBounds, BaseTransform baseTransform) {
                return ((Parent)node).doComputeGeomBounds(baseBounds, baseTransform);
            }

            @Override
            public boolean doComputeContains(Node node, double d2, double d3) {
                return ((Parent)node).doComputeContains(d2, d3);
            }

            @Override
            public void doProcessCSS(Node node) {
                ((Parent)node).doProcessCSS();
            }

            @Override
            public void doPickNodeLocal(Node node, PickRay pickRay, PickResultChooser pickResultChooser) {
                ((Parent)node).doPickNodeLocal(pickRay, pickResultChooser);
            }

            @Override
            public boolean pickChildrenNode(Parent parent, PickRay pickRay, PickResultChooser pickResultChooser) {
                return parent.pickChildrenNode(pickRay, pickResultChooser);
            }

            @Override
            public void setTraversalEngine(Parent parent, ParentTraversalEngine parentTraversalEngine) {
                parent.setTraversalEngine(parentTraversalEngine);
            }

            @Override
            public ParentTraversalEngine getTraversalEngine(Parent parent) {
                return parent.getTraversalEngine();
            }

            @Override
            public List<String> doGetAllParentStylesheets(Parent parent) {
                return parent.doGetAllParentStylesheets();
            }
        });
    }
}

