/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ListCellBehavior;
import javafx.geometry.Orientation;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.CellSkinBase;

public class ListCellSkin<T>
extends CellSkinBase<ListCell<T>> {
    private final BehaviorBase<ListCell<T>> behavior;

    public ListCellSkin(ListCell<T> listCell) {
        super(listCell);
        this.behavior = new ListCellBehavior<T>(listCell);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = super.computePrefWidth(d2, d3, d4, d5, d6);
        ListView listView = ((ListCell)this.getSkinnable()).getListView();
        return listView == null ? 0.0 : (listView.getOrientation() == Orientation.VERTICAL ? d7 : Math.max(d7, this.getCellSize()));
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.getFixedCellSize();
        if (d7 > 0.0) {
            return d7;
        }
        double d8 = this.getCellSize();
        double d9 = d8 == 24.0 ? super.computePrefHeight(d2, d3, d4, d5, d6) : d8;
        return d9;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.getFixedCellSize();
        if (d7 > 0.0) {
            return d7;
        }
        return super.computeMinHeight(d2, d3, d4, d5, d6);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.getFixedCellSize();
        if (d7 > 0.0) {
            return d7;
        }
        return super.computeMaxHeight(d2, d3, d4, d5, d6);
    }

    private double getFixedCellSize() {
        ListView listView = ((ListCell)this.getSkinnable()).getListView();
        return listView != null ? listView.getFixedCellSize() : -1.0;
    }
}

