/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.ControlAcceleratorSupport;
import com.sun.javafx.scene.control.LabeledImpl;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.MenuButtonBehaviorBase;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ContextMenuSkin;
import javafx.scene.input.Mnemonic;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class MenuButtonSkinBase<C extends MenuButton>
extends SkinBase<C> {
    final LabeledImpl label;
    final StackPane arrow;
    final StackPane arrowButton;
    ContextMenu popup;
    boolean behaveLikeButton = false;
    boolean requestFocusOnFirstMenuItem = false;

    public MenuButtonSkinBase(C c2) {
        super(c2);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        if (((Node)c2).getOnMousePressed() == null) {
            listenerHelper.addEventHandler((EventTarget)c2, MouseEvent.MOUSE_PRESSED, mouseEvent -> {
                MenuButtonBehaviorBase<C> menuButtonBehaviorBase = this.getBehavior();
                if (menuButtonBehaviorBase != null) {
                    menuButtonBehaviorBase.mousePressed((MouseEvent)mouseEvent, this.behaveLikeButton);
                }
            });
        }
        if (((Node)c2).getOnMouseReleased() == null) {
            listenerHelper.addEventHandler((EventTarget)c2, MouseEvent.MOUSE_RELEASED, mouseEvent -> {
                MenuButtonBehaviorBase<C> menuButtonBehaviorBase = this.getBehavior();
                if (menuButtonBehaviorBase != null) {
                    menuButtonBehaviorBase.mouseReleased((MouseEvent)mouseEvent, this.behaveLikeButton);
                }
            });
        }
        this.label = new MenuLabeledImpl((MenuButton)this.getSkinnable());
        this.label.setMnemonicParsing(((Labeled)c2).isMnemonicParsing());
        this.label.setLabelFor((Node)c2);
        this.arrow = new StackPane();
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrowButton = new StackPane();
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        this.popup = new ContextMenu();
        this.popup.getItems().clear();
        this.popup.getItems().addAll((Collection<MenuItem>)((MenuButton)this.getSkinnable()).getItems());
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.label, this.arrowButton});
        ((MenuButton)this.getSkinnable()).requestLayout();
        listenerHelper.addListChangeListener(((MenuButton)c2).getItems(), change -> {
            while (change.next()) {
                this.popup.getItems().removeAll(change.getRemoved());
                this.popup.getItems().addAll(change.getFrom(), change.getAddedSubList());
            }
        });
        ArrayList arrayList = new ArrayList();
        listenerHelper.addChangeListener(((Node)c2).sceneProperty(), true, (observableValue, scene, scene2) -> {
            if (scene != null) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(((MenuButton)this.getSkinnable()).getItems(), scene);
                this.removeMnemonicsFromScene(arrayList, (Scene)scene);
            }
            if (((MenuButton)this.getSkinnable()).getScene() != null) {
                ControlAcceleratorSupport.addAcceleratorsIntoScene(((MenuButton)this.getSkinnable()).getItems(), (Node)((Object)this.getSkinnable()));
            }
        });
        listenerHelper.addChangeListener(((MenuButton)c2).showingProperty(), bl -> {
            if (((MenuButton)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        });
        listenerHelper.addChangeListener(((Node)c2).focusedProperty(), bl -> {
            if (!((MenuButton)this.getSkinnable()).isFocused() && ((MenuButton)this.getSkinnable()).isShowing()) {
                this.hide();
            }
            if (!((MenuButton)this.getSkinnable()).isFocused() && this.popup.isShowing()) {
                this.hide();
            }
        });
        listenerHelper.addChangeListener(((Labeled)c2).mnemonicParsingProperty(), bl -> {
            this.label.setMnemonicParsing(((MenuButton)this.getSkinnable()).isMnemonicParsing());
            ((MenuButton)this.getSkinnable()).requestLayout();
        });
        listenerHelper.addChangeListener(this.popup.showingProperty(), bl -> {
            if (!this.popup.isShowing() && ((MenuButton)this.getSkinnable()).isShowing()) {
                ((MenuButton)this.getSkinnable()).hide();
            }
            if (this.popup.isShowing()) {
                boolean bl2 = NodeHelper.isShowMnemonics((Node)((Object)this.getSkinnable()));
                Utils.addMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene(), bl2, arrayList);
            } else {
                Scene scene = ((MenuButton)this.getSkinnable()).getScene();
                if (scene != null) {
                    this.removeMnemonicsFromScene(arrayList, scene);
                }
            }
        });
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (((MenuButton)this.getSkinnable()).getScene() != null) {
            ControlAcceleratorSupport.removeAcceleratorsFromScene(((MenuButton)this.getSkinnable()).getItems(), ((MenuButton)this.getSkinnable()).getScene());
        }
        super.dispose();
        if (this.popup != null) {
            if (this.popup.getSkin() != null && this.popup.getSkin().getNode() != null) {
                ContextMenuContent contextMenuContent = (ContextMenuContent)this.popup.getSkin().getNode();
                contextMenuContent.dispose();
            }
            this.popup.setSkin(null);
            this.popup = null;
        }
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + this.label.minWidth(d2) + this.snapSizeX(this.arrowButton.minWidth(d2)) + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + Math.max(this.label.minHeight(d2), this.snapSizeY(this.arrowButton.minHeight(-1.0))) + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + this.label.prefWidth(d2) + this.snapSizeX(this.arrowButton.prefWidth(d2)) + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + Math.max(this.label.prefHeight(d2), this.snapSizeY(this.arrowButton.prefHeight(-1.0))) + d5;
    }

    @Override
    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((MenuButton)this.getSkinnable()).prefWidth(d2);
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((MenuButton)this.getSkinnable()).prefHeight(d2);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.snapSizeX(this.arrowButton.prefWidth(-1.0));
        this.label.resizeRelocate(d2, d3, d4 - d6, d5);
        this.arrowButton.resizeRelocate(d2 + (d4 - d6), d3, d6, d5);
    }

    MenuButtonBehaviorBase<C> getBehavior() {
        return null;
    }

    private void show() {
        if (!this.popup.isShowing()) {
            this.popup.show((Node)((Object)this.getSkinnable()), ((MenuButton)this.getSkinnable()).getPopupSide(), 0.0, 0.0);
        }
    }

    private void hide() {
        if (this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private void removeMnemonicsFromScene(List<Mnemonic> list, Scene scene) {
        ArrayList<Mnemonic> arrayList = new ArrayList<Mnemonic>(list);
        list.clear();
        Platform.runLater(() -> arrayList.forEach(scene::removeMnemonic));
    }

    void requestFocusOnFirstMenuItem() {
        this.requestFocusOnFirstMenuItem = true;
    }

    void putFocusOnFirstMenuItem() {
        Node node;
        Skin<?> skin = this.popup.getSkin();
        if (skin instanceof ContextMenuSkin && (node = skin.getNode()) instanceof ContextMenuContent) {
            ((ContextMenuContent)node).requestFocusOnIndex(0);
        }
    }

    private static class MenuLabeledImpl
    extends LabeledImpl {
        MenuButton button;

        public MenuLabeledImpl(MenuButton menuButton) {
            super(menuButton);
            this.button = menuButton;
            this.addEventHandler(ActionEvent.ACTION, (? super T actionEvent) -> {
                this.button.fireEvent(new ActionEvent());
                actionEvent.consume();
            });
        }
    }
}

