/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableSkinUtils;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public abstract class TableViewSkinBase<M, S, C extends Control, I extends IndexedCell<M>, TC extends TableColumnBase<S, ?>>
extends VirtualContainerBase<C, I> {
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;
    private static final boolean IS_PANNABLE = Boolean.getBoolean("javafx.scene.control.skin.TableViewSkin.pannable");
    private final String EMPTY_TABLE_TEXT = ControlResources.getString("TableView.noContent");
    private final String NO_COLUMNS_TEXT = ControlResources.getString("TableView.noColumns");
    VirtualFlow<I> flow;
    private boolean contentWidthDirty = true;
    private Region columnReorderLine;
    private Region columnReorderOverlay;
    private TableHeaderRow tableHeaderRow;
    private Callback<C, I> rowFactory;
    private StackPane placeholderRegion;
    private Label placeholderLabel;
    private int visibleColCount;
    boolean needCellsRecreated = true;
    boolean needCellsReconfigured = false;
    private int itemCount = -1;
    private ListChangeListener<S> rowCountListener = change -> {
        while (change.next()) {
            if (change.wasReplaced()) {
                this.itemCount = 0;
                break;
            }
            if (change.getRemovedSize() != this.itemCount) continue;
            this.itemCount = 0;
            break;
        }
        if (this.getSkinnable() instanceof TableView) {
            ((TableView)this.getSkinnable()).edit(-1, null);
        }
        this.markItemCountDirty();
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    };
    private InvalidationListener widthListener = observable -> {
        this.needCellsReconfigured = true;
        if (this.getSkinnable() != null) {
            ((Parent)((Object)this.getSkinnable())).requestLayout();
        }
    };
    private WeakListChangeListener<S> weakRowCountListener = new WeakListChangeListener<S>(this.rowCountListener);
    private WeakInvalidationListener weakWidthListener = new WeakInvalidationListener(this.widthListener);

    public TableViewSkinBase(C c2) {
        super(c2);
        this.flow = this.getVirtualFlow();
        this.flow.setPannable(IS_PANNABLE);
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addInvalidationListener(this.flow.getHbar().valueProperty(), observable -> this.horizontalScroll());
        this.flow.getHbar().setUnitIncrement(15.0);
        this.flow.getHbar().setBlockIncrement(80.0);
        this.columnReorderLine = new Region();
        this.columnReorderLine.getStyleClass().setAll((String[])new String[]{"column-resize-line"});
        this.columnReorderLine.setManaged(false);
        this.columnReorderLine.setVisible(false);
        this.columnReorderOverlay = new Region();
        this.columnReorderOverlay.getStyleClass().setAll((String[])new String[]{"column-overlay"});
        this.columnReorderOverlay.setVisible(false);
        this.columnReorderOverlay.setManaged(false);
        this.tableHeaderRow = this.createTableHeaderRow();
        this.tableHeaderRow.setFocusTraversable(false);
        this.getChildren().addAll((Node[])new Node[]{this.tableHeaderRow, this.flow, this.columnReorderOverlay, this.columnReorderLine});
        this.updateVisibleColumnCount();
        this.updateVisibleLeafColumnWidthListeners(this.getVisibleLeafColumns(), FXCollections.emptyObservableList());
        listenerHelper.addInvalidationListener(this.tableHeaderRow.reorderingProperty(), observable -> ((Parent)((Object)this.getSkinnable())).requestLayout());
        listenerHelper.addListChangeListener(this.getVisibleLeafColumns(), change -> {
            this.updateVisibleColumnCount();
            while (change.next()) {
                this.updateVisibleLeafColumnWidthListeners(change.getAddedSubList(), change.getRemoved());
            }
        });
        final ObjectProperty objectProperty = TableSkinUtils.itemsProperty(this);
        this.updateTableItems(null, (ObservableList)objectProperty.get());
        listenerHelper.addInvalidationListener(objectProperty, new InvalidationListener(){
            private WeakReference<ObservableList<S>> weakItemsRef;
            final /* synthetic */ TableViewSkinBase this$0;
            {
                this.this$0 = tableViewSkinBase;
                this.weakItemsRef = new WeakReference<ObservableList>((ObservableList)objectProperty.get());
            }

            @Override
            public void invalidated(Observable observable) {
                ObservableList observableList = (ObservableList)this.weakItemsRef.get();
                this.weakItemsRef = new WeakReference<ObservableList>((ObservableList)objectProperty.get());
                this.this$0.updateTableItems(observableList, (ObservableList)objectProperty.get());
            }
        });
        ObservableMap<Object, Object> observableMap = ((Node)c2).getProperties();
        observableMap.remove("refreshKey");
        observableMap.remove("recreateKey");
        listenerHelper.addMapChangeListener(observableMap, change -> {
            if (!change.wasAdded()) {
                return;
            }
            if ("refreshKey".equals(change.getKey())) {
                this.refreshView();
                ((Node)((Object)this.getSkinnable())).getProperties().remove("refreshKey");
            } else if ("recreateKey".equals(change.getKey())) {
                this.needCellsRecreated = true;
                this.refreshView();
                ((Node)((Object)this.getSkinnable())).getProperties().remove("recreateKey");
            }
        });
        listenerHelper.addEventHandler((EventTarget)c2, ScrollToEvent.scrollToColumn(), scrollToEvent -> this.scrollHorizontally((TableColumnBase)scrollToEvent.getScrollTarget()));
        listenerHelper.addInvalidationListener(() -> {
            this.contentWidthDirty = true;
            ((Parent)((Object)this.getSkinnable())).requestLayout();
        }, this.flow.widthProperty(), this.flow.getVbar().widthProperty());
        ObjectProperty objectProperty2 = TableSkinUtils.rowFactoryProperty(this);
        listenerHelper.addChangeListener(objectProperty2, callback -> {
            Callback<C, I> callback2 = this.rowFactory;
            this.rowFactory = (Callback)objectProperty2.get();
            if (callback2 != this.rowFactory) {
                this.flow.recreateCells();
            }
        });
        listenerHelper.addChangeListener(TableSkinUtils.placeholderProperty(this), node -> this.updatePlaceholderRegionVisibility());
        listenerHelper.addChangeListener(this.flow.getVbar().visibleProperty(), bl -> this.updateContentWidth());
        listenerHelper.addChangeListener(TableSkinUtils.columnResizePolicyProperty(this), callback -> this.updateSuppressBreadthBar());
        this.updateSuppressBreadthBar();
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (this.placeholderRegion != null) {
            this.getChildren().remove(this.placeholderRegion);
        }
        this.getChildren().removeAll((Node[])new Node[]{this.tableHeaderRow, this.flow, this.columnReorderOverlay, this.columnReorderLine});
        ObjectProperty objectProperty = TableSkinUtils.itemsProperty(this);
        this.updateTableItems((ObservableList)objectProperty.get(), null);
        super.dispose();
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return 400.0;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.computePrefHeight(-1.0, d3, d4, d5, d6);
        ObservableList<TC> observableList = this.getVisibleLeafColumns();
        if (observableList == null || observableList.isEmpty()) {
            return d7 * 0.618033987;
        }
        double d8 = d6 + d4;
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i2);
            d8 += Math.max(tableColumnBase.getPrefWidth(), tableColumnBase.getMinWidth());
        }
        return Math.max(d8, d7 * 0.618033987);
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Skinnable skinnable = this.getSkinnable();
        if (skinnable == null) {
            return;
        }
        super.layoutChildren(d2, d3, d4, d5);
        if (this.needCellsRecreated) {
            this.flow.recreateCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRecreated = false;
        this.needCellsReconfigured = false;
        double d6 = ((Node)((Object)skinnable)).getLayoutBounds().getHeight() / 2.0;
        double d7 = this.tableHeaderRow.prefHeight(-1.0);
        this.layoutInArea(this.tableHeaderRow, d2, d3, d4, d7, d6, HPos.CENTER, VPos.CENTER);
        double d8 = d3 + d7;
        double d9 = Math.floor(d5 - d7);
        if (this.getItemCount() == 0 || this.visibleColCount == 0) {
            this.layoutInArea(this.placeholderRegion, d2, d8, d4, d9, d6, HPos.CENTER, VPos.CENTER);
        } else {
            this.layoutInArea(this.flow, d2, d8, d4, d9, d6, HPos.CENTER, VPos.CENTER);
        }
        if (this.tableHeaderRow.getReorderingRegion() != null) {
            TableColumnHeader tableColumnHeader = this.tableHeaderRow.getReorderingRegion();
            TableColumnBase<?, ?> tableColumnBase = tableColumnHeader.getTableColumn();
            if (tableColumnBase != null) {
                TableColumnHeader tableColumnHeader2 = this.tableHeaderRow.getReorderingRegion();
                double d10 = this.tableHeaderRow.sceneToLocal(tableColumnHeader2.localToScene(tableColumnHeader2.getBoundsInLocal())).getMinX();
                double d11 = tableColumnHeader.getWidth();
                if (d10 < 0.0) {
                    d11 += d10;
                }
                double d12 = d10 = d10 < 0.0 ? 0.0 : d10;
                if (d10 + d11 > d4) {
                    d11 = d4 - d10;
                    if (this.flow.getVbar().isVisible()) {
                        d11 -= this.flow.getVbar().getWidth() - 1.0;
                    }
                }
                double d13 = d9;
                if (this.flow.getHbar().isVisible()) {
                    d13 -= this.flow.getHbar().getHeight();
                }
                double d14 = d2 + d10;
                this.columnReorderOverlay.resizeRelocate(d14, d8, d11, d13);
            }
            double d15 = this.columnReorderLine.snappedLeftInset() + this.columnReorderLine.snappedRightInset();
            double d16 = d5 - (this.flow.getHbar().isVisible() ? this.flow.getHbar().getHeight() - 1.0 : 0.0);
            this.columnReorderLine.resizeRelocate(d2, d3, d15, d16);
        }
        this.columnReorderLine.setVisible(this.tableHeaderRow.isReordering());
        this.columnReorderOverlay.setVisible(this.tableHeaderRow.isReordering());
        this.checkContentWidthState();
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new TableHeaderRow(this);
    }

    protected TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    private TableSelectionModel<S> getSelectionModel() {
        return TableSkinUtils.getSelectionModel(this);
    }

    private TableFocusModel<M, ?> getFocusModel() {
        return TableSkinUtils.getFocusModel(this);
    }

    private TablePositionBase<? extends TC> getFocusedCell() {
        return TableSkinUtils.getFocusedCell(this);
    }

    private ObservableList<? extends TC> getVisibleLeafColumns() {
        return TableSkinUtils.getVisibleLeafColumns(this);
    }

    @Override
    protected void updateItemCount() {
        int n2;
        this.updatePlaceholderRegionVisibility();
        int n3 = this.itemCount;
        this.itemCount = n2 = this.getItemCount();
        if (this.itemCount == 0) {
            this.flow.getHbar().setValue(0.0);
        }
        this.flow.setCellCount(n2);
        if (n2 == n3) {
            this.needCellsReconfigured = true;
        } else if (n3 == 0) {
            this.requestRebuildCells();
        }
    }

    private void checkContentWidthState() {
        if (this.contentWidthDirty || this.getItemCount() == 0) {
            this.updateContentWidth();
            this.contentWidthDirty = false;
        }
    }

    void horizontalScroll() {
        this.tableHeaderRow.updateScrollX();
    }

    protected void onFocusAboveCell() {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        this.flow.scrollTo(tableFocusModel.getFocusedIndex());
    }

    protected void onFocusBelowCell() {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        this.flow.scrollTo(tableFocusModel.getFocusedIndex());
    }

    protected void onSelectAboveCell() {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        this.flow.scrollTo(tableSelectionModel.getSelectedIndex());
    }

    protected void onSelectBelowCell() {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        this.flow.scrollTo(tableSelectionModel.getSelectedIndex());
    }

    protected void onSelectLeftCell() {
        this.scrollHorizontally();
    }

    protected void onSelectRightCell() {
        this.scrollHorizontally();
    }

    protected void onFocusLeftCell() {
        this.scrollHorizontally();
    }

    protected void onFocusRightCell() {
        this.scrollHorizontally();
    }

    protected void onMoveToFirstCell() {
        this.flow.scrollTo(0);
        this.flow.setPosition(0.0);
    }

    protected void onMoveToLastCell() {
        int n2 = this.getItemCount();
        this.flow.scrollTo(n2);
        this.flow.setPosition(1.0);
    }

    private void updateTableItems(ObservableList<S> observableList, ObservableList<S> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakRowCountListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakRowCountListener);
        }
        this.markItemCountDirty();
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    }

    Region getColumnReorderLine() {
        return this.columnReorderLine;
    }

    protected int onScrollPageDown(boolean bl) {
        int n2;
        boolean bl2;
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return -1;
        }
        int n3 = this.getItemCount();
        I i2 = this.flow.getLastVisibleCellWithinViewport();
        if (i2 == null) {
            return -1;
        }
        int n4 = ((IndexedCell)i2).getIndex();
        int n5 = n4 = n4 >= n3 ? n3 - 1 : n4;
        if (bl) {
            bl2 = ((Node)i2).isFocused() || this.isCellFocused(n4);
        } else {
            boolean bl3 = bl2 = ((Cell)i2).isSelected() || this.isCellSelected(n4);
        }
        if (bl2 && (n2 = (int)(this.isLeadIndex(bl, n4) ? 1 : 0)) != 0) {
            this.flow.scrollToTop(i2);
            I i3 = this.flow.getLastVisibleCellWithinViewport();
            i2 = i3 == null ? i2 : i3;
        }
        n2 = (n2 = ((IndexedCell)i2).getIndex()) >= n3 ? n3 - 1 : n2;
        this.flow.scrollTo(n2);
        return n2;
    }

    protected int onScrollPageUp(boolean bl) {
        int n2;
        I i2 = this.flow.getFirstVisibleCellWithinViewport();
        if (i2 == null) {
            return -1;
        }
        int n3 = ((IndexedCell)i2).getIndex();
        boolean bl2 = false;
        if (bl) {
            bl2 = ((Node)i2).isFocused() || this.isCellFocused(n3);
        } else {
            boolean bl3 = bl2 = ((Cell)i2).isSelected() || this.isCellSelected(n3);
        }
        if (bl2 && (n2 = (int)(this.isLeadIndex(bl, n3) ? 1 : 0)) != 0) {
            this.flow.scrollToBottom(i2);
            I i3 = this.flow.getFirstVisibleCellWithinViewport();
            i2 = i3 == null ? i2 : i3;
        }
        n2 = ((IndexedCell)i2).getIndex();
        this.flow.scrollTo(n2);
        return n2;
    }

    private boolean isLeadIndex(boolean bl, int n2) {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return false;
        }
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        return bl && tableFocusModel.getFocusedIndex() == n2 || !bl && tableSelectionModel.getSelectedIndex() == n2;
    }

    private void updateVisibleColumnCount() {
        this.visibleColCount = this.getVisibleLeafColumns().size();
        this.updatePlaceholderRegionVisibility();
        this.requestRebuildCells();
    }

    private void updateVisibleLeafColumnWidthListeners(List<? extends TC> list, List<? extends TC> list2) {
        TableColumnBase tableColumnBase;
        int n2;
        int n3 = list2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tableColumnBase = (TableColumnBase)list2.get(n2);
            tableColumnBase.widthProperty().removeListener(this.weakWidthListener);
        }
        n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            tableColumnBase = (TableColumnBase)list.get(n2);
            tableColumnBase.widthProperty().addListener(this.weakWidthListener);
        }
        this.requestRebuildCells();
    }

    final void updatePlaceholderRegionVisibility() {
        boolean bl;
        boolean bl2 = bl = this.visibleColCount == 0 || this.getItemCount() == 0;
        if (bl) {
            Node node;
            if (this.placeholderRegion == null) {
                this.placeholderRegion = new StackPane();
                this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                this.getChildren().add(this.placeholderRegion);
            }
            if ((node = (Node)TableSkinUtils.placeholderProperty(this).get()) == null) {
                if (this.placeholderLabel == null) {
                    this.placeholderLabel = new Label();
                }
                String string = this.visibleColCount == 0 ? this.NO_COLUMNS_TEXT : this.EMPTY_TABLE_TEXT;
                this.placeholderLabel.setText(string);
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderLabel});
            } else {
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{node});
            }
        }
        this.flow.setVisible(!bl);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(bl);
        }
    }

    private void updateContentWidth() {
        double d2 = this.flow.getWidth();
        if (this.flow.getVbar().isVisible()) {
            d2 -= this.flow.getVbar().getWidth();
        }
        if (d2 <= 0.0 || this.getItemCount() == 0) {
            Skinnable skinnable = this.getSkinnable();
            d2 = ((Region)((Object)skinnable)).getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        }
        d2 = Math.max(0.0, d2);
        ((Node)((Object)this.getSkinnable())).getProperties().put("TableView.contentWidth", Math.floor(d2));
    }

    void updateSuppressBreadthBar() {
        Callback callback = (Callback)TableSkinUtils.columnResizePolicyProperty(this).get();
        boolean bl = TableSkinUtils.isConstrainedResizePolicy(callback);
        this.flow.setSuppressBreadthBar(bl);
    }

    private void refreshView() {
        this.markItemCountDirty();
        Skinnable skinnable = this.getSkinnable();
        if (skinnable != null) {
            ((Parent)((Object)skinnable)).requestLayout();
        }
    }

    public void scrollHorizontally() {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TC TC = this.getFocusedCell().getTableColumn();
        this.scrollHorizontally(TC);
    }

    protected void scrollHorizontally(TC TC) {
        double d2;
        TableColumnBase tableColumnBase;
        if (TC == null || !((TableColumnBase)TC).isVisible()) {
            return;
        }
        Skinnable skinnable = this.getSkinnable();
        TableColumnHeader tableColumnHeader = this.tableHeaderRow.getColumnHeaderFor((TableColumnBase<?, ?>)TC);
        if (tableColumnHeader == null || tableColumnHeader.getWidth() <= 0.0) {
            Platform.runLater(() -> this.scrollHorizontally(TC));
            return;
        }
        double d3 = 0.0;
        Iterator iterator = this.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && !(tableColumnBase = (TableColumnBase)iterator.next()).equals(TC)) {
            d3 += tableColumnBase.getWidth();
        }
        double d4 = d3 + ((TableColumnBase)TC).getWidth();
        double d5 = ((Region)((Object)skinnable)).getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double d6 = this.flow.getHbar().getValue();
        double d7 = this.flow.getHbar().getMax();
        if (d3 < d6 && d3 >= 0.0) {
            d2 = d3;
        } else {
            double d8 = d3 < 0.0 || d4 > d5 ? d3 - d6 : 0.0;
            d2 = d6 + d8 > d7 ? d7 : d6 + d8;
        }
        this.flow.getHbar().setValue(d2);
    }

    private boolean isCellSelected(int n2) {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return false;
        }
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            return false;
        }
        int n3 = this.getVisibleLeafColumns().size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!tableSelectionModel.isSelected(n2, (TableColumnBase<S, ?>)TableSkinUtils.getVisibleLeafColumn(this, i2))) continue;
            return true;
        }
        return false;
    }

    private boolean isCellFocused(int n2) {
        TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return false;
        }
        int n3 = this.getVisibleLeafColumns().size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!tableFocusModel.isFocused(n2, TableSkinUtils.getVisibleLeafColumn(this, i2))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case FOCUS_ITEM: {
                TableFocusModel<M, ?> tableFocusModel = this.getFocusModel();
                if (tableFocusModel == null) {
                    return null;
                }
                int n2 = tableFocusModel.getFocusedIndex();
                if (n2 == -1) {
                    if (this.placeholderRegion != null && this.placeholderRegion.isVisible()) {
                        return this.placeholderRegion.getChildren().get(0);
                    }
                    if (this.getItemCount() > 0) {
                        n2 = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(n2);
            }
            case CELL_AT_ROW_COLUMN: {
                int n3 = (Integer)objectArray[0];
                return this.flow.getPrivateCell(n3);
            }
            case COLUMN_AT_INDEX: {
                int n4 = (Integer)objectArray[0];
                Object TC = TableSkinUtils.getVisibleLeafColumn(this, n4);
                return this.getTableHeaderRow().getColumnHeaderFor((TableColumnBase<?, ?>)TC);
            }
            case HEADER: {
                return this.getTableHeaderRow();
            }
            case VERTICAL_SCROLLBAR: {
                return this.flow.getVbar();
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

