/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class AnchorPane
extends Pane {
    private static final String TOP_ANCHOR = "pane-top-anchor";
    private static final String LEFT_ANCHOR = "pane-left-anchor";
    private static final String BOTTOM_ANCHOR = "pane-bottom-anchor";
    private static final String RIGHT_ANCHOR = "pane-right-anchor";

    public static void setTopAnchor(Node node, Double d2) {
        AnchorPane.setConstraint(node, TOP_ANCHOR, d2);
    }

    public static Double getTopAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, TOP_ANCHOR);
    }

    public static void setLeftAnchor(Node node, Double d2) {
        AnchorPane.setConstraint(node, LEFT_ANCHOR, d2);
    }

    public static Double getLeftAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, LEFT_ANCHOR);
    }

    public static void setBottomAnchor(Node node, Double d2) {
        AnchorPane.setConstraint(node, BOTTOM_ANCHOR, d2);
    }

    public static Double getBottomAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, BOTTOM_ANCHOR);
    }

    public static void setRightAnchor(Node node, Double d2) {
        AnchorPane.setConstraint(node, RIGHT_ANCHOR, d2);
    }

    public static Double getRightAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, RIGHT_ANCHOR);
    }

    public static void clearConstraints(Node node) {
        AnchorPane.setTopAnchor(node, null);
        AnchorPane.setRightAnchor(node, null);
        AnchorPane.setBottomAnchor(node, null);
        AnchorPane.setLeftAnchor(node, null);
    }

    public AnchorPane() {
    }

    public AnchorPane(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    @Override
    protected double computeMinWidth(double d2) {
        return this.computeWidth(true, d2);
    }

    @Override
    protected double computeMinHeight(double d2) {
        return this.computeHeight(true, d2);
    }

    @Override
    protected double computePrefWidth(double d2) {
        return this.computeWidth(false, d2);
    }

    @Override
    protected double computePrefHeight(double d2) {
        return this.computeHeight(false, d2);
    }

    private double computeWidth(boolean bl, double d2) {
        double d3 = 0.0;
        double d4 = d2 != -1.0 ? d2 - this.getInsets().getTop() - this.getInsets().getBottom() : -1.0;
        List list = this.getManagedChildren();
        for (Node node : list) {
            Double d5 = this.getSnappedLeftAnchor(node);
            Double d6 = this.getSnappedRightAnchor(node);
            double d7 = d5 != null ? d5 : (d6 != null ? 0.0 : node.getLayoutBounds().getMinX() + node.getLayoutX());
            double d8 = d6 != null ? d6 : 0.0;
            double d9 = -1.0;
            if (node.getContentBias() == Orientation.VERTICAL && d4 != -1.0) {
                d9 = this.computeChildHeight(node, this.getSnappedTopAnchor(node), this.getSnappedBottomAnchor(node), d4, -1.0);
            }
            d3 = Math.max(d3, d7 + (bl && d5 != null && d6 != null ? node.minWidth(d9) : this.computeChildPrefAreaWidth(node, -1.0, null, d9, false)) + d8);
        }
        return this.snappedLeftInset() + d3 + this.snappedRightInset();
    }

    private Double getSnappedTopAnchor(Node node) {
        Double d2 = AnchorPane.getTopAnchor(node);
        if (d2 == null) {
            return null;
        }
        return this.snapPositionY(d2);
    }

    private Double getSnappedBottomAnchor(Node node) {
        Double d2 = AnchorPane.getBottomAnchor(node);
        if (d2 == null) {
            return null;
        }
        return this.snapPositionY(d2);
    }

    private Double getSnappedLeftAnchor(Node node) {
        Double d2 = AnchorPane.getLeftAnchor(node);
        if (d2 == null) {
            return null;
        }
        return this.snapPositionX(d2);
    }

    private Double getSnappedRightAnchor(Node node) {
        Double d2 = AnchorPane.getRightAnchor(node);
        if (d2 == null) {
            return null;
        }
        return this.snapPositionX(d2);
    }

    private double computeHeight(boolean bl, double d2) {
        double d3 = 0.0;
        double d4 = d2 != -1.0 ? d2 - this.getInsets().getLeft() - this.getInsets().getRight() : -1.0;
        List list = this.getManagedChildren();
        for (Node node : list) {
            Double d5 = this.getSnappedTopAnchor(node);
            Double d6 = this.getSnappedBottomAnchor(node);
            double d7 = d5 != null ? d5 : (d6 != null ? 0.0 : node.getLayoutBounds().getMinY() + node.getLayoutY());
            double d8 = d6 != null ? d6 : 0.0;
            double d9 = -1.0;
            if (node.getContentBias() == Orientation.HORIZONTAL && d4 != -1.0) {
                d9 = this.computeChildWidth(node, this.getSnappedLeftAnchor(node), this.getSnappedRightAnchor(node), d4, -1.0);
            }
            d3 = Math.max(d3, d7 + (bl && d5 != null && d6 != null ? node.minHeight(d9) : this.computeChildPrefAreaHeight(node, -1.0, null, d9)) + d8);
        }
        return this.snappedTopInset() + d3 + this.snappedBottomInset();
    }

    private double computeChildWidth(Node node, Double d2, Double d3, double d4, double d5) {
        if (d2 != null && d3 != null && node.isResizable()) {
            return d4 - this.snappedLeftInset() - this.snappedRightInset() - d2 - d3;
        }
        return this.computeChildPrefAreaWidth(node, -1.0, Insets.EMPTY, d5, true);
    }

    private double computeChildHeight(Node node, Double d2, Double d3, double d4, double d5) {
        if (d2 != null && d3 != null && node.isResizable()) {
            return d4 - this.snappedTopInset() - this.snappedBottomInset() - d2 - d3;
        }
        return this.computeChildPrefAreaHeight(node, -1.0, Insets.EMPTY, d5);
    }

    @Override
    protected void layoutChildren() {
        List list = this.getManagedChildren();
        for (Node node : list) {
            double d2;
            double d3;
            Double d4 = this.getSnappedTopAnchor(node);
            Double d5 = this.getSnappedBottomAnchor(node);
            Double d6 = this.getSnappedLeftAnchor(node);
            Double d7 = this.getSnappedRightAnchor(node);
            Bounds bounds = node.getLayoutBounds();
            Orientation orientation = node.getContentBias();
            double d8 = node.getLayoutX() + bounds.getMinX();
            double d9 = node.getLayoutY() + bounds.getMinY();
            if (orientation == Orientation.VERTICAL) {
                d3 = this.computeChildHeight(node, d4, d5, this.getHeight(), -1.0);
                d2 = this.computeChildWidth(node, d6, d7, this.getWidth(), d3);
            } else if (orientation == Orientation.HORIZONTAL) {
                d2 = this.computeChildWidth(node, d6, d7, this.getWidth(), -1.0);
                d3 = this.computeChildHeight(node, d4, d5, this.getHeight(), d2);
            } else {
                d2 = this.computeChildWidth(node, d6, d7, this.getWidth(), -1.0);
                d3 = this.computeChildHeight(node, d4, d5, this.getHeight(), -1.0);
            }
            if (d6 != null) {
                d8 = this.snappedLeftInset() + d6;
            } else if (d7 != null) {
                d8 = this.getWidth() - this.snappedRightInset() - d7 - d2;
            }
            if (d4 != null) {
                d9 = this.snappedTopInset() + d4;
            } else if (d5 != null) {
                d9 = this.getHeight() - this.snappedBottomInset() - d5 - d3;
            }
            node.resizeRelocate(d8, d9, d2, d3);
        }
    }
}

