/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.util.InterpolationUtils;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;

public final class BackgroundSize
implements Interpolatable<BackgroundSize> {
    public static final double AUTO = -1.0;
    public static final BackgroundSize DEFAULT = new BackgroundSize(-1.0, -1.0, true, true, false, false);
    private final double width;
    private final double height;
    private final boolean widthAsPercentage;
    private final boolean heightAsPercentage;
    private final boolean contain;
    private final boolean cover;
    private final int hash;

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final boolean isWidthAsPercentage() {
        return this.widthAsPercentage;
    }

    public final boolean isHeightAsPercentage() {
        return this.heightAsPercentage;
    }

    public final boolean isContain() {
        return this.contain;
    }

    public final boolean isCover() {
        return this.cover;
    }

    public BackgroundSize(@NamedArg(value="width") double d2, @NamedArg(value="height") double d3, @NamedArg(value="widthAsPercentage") boolean bl, @NamedArg(value="heightAsPercentage") boolean bl2, @NamedArg(value="contain") boolean bl3, @NamedArg(value="cover") boolean bl4) {
        if (d2 < 0.0 && d2 != -1.0) {
            throw new IllegalArgumentException("Width cannot be < 0, except when AUTO");
        }
        if (d3 < 0.0 && d3 != -1.0) {
            throw new IllegalArgumentException("Height cannot be < 0, except when AUTO");
        }
        this.width = d2;
        this.height = d3;
        this.widthAsPercentage = bl;
        this.heightAsPercentage = bl2;
        this.contain = bl3;
        this.cover = bl4;
        int n2 = this.widthAsPercentage ? 1 : 0;
        n2 = 31 * n2 + (this.heightAsPercentage ? 1 : 0);
        long l2 = this.width != 0.0 ? Double.doubleToLongBits(this.width) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.height != 0.0 ? Double.doubleToLongBits(this.height) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 31 * n2 + (this.cover ? 1 : 0);
        this.hash = n2 = 31 * n2 + (this.contain ? 1 : 0);
    }

    @Override
    public BackgroundSize interpolate(BackgroundSize backgroundSize, double d2) {
        boolean bl;
        boolean bl2;
        Objects.requireNonNull(backgroundSize, "endValue cannot be null");
        if (d2 <= 0.0) {
            return this;
        }
        if (d2 >= 1.0) {
            return backgroundSize;
        }
        if (this.cover || this.contain || backgroundSize.cover || backgroundSize.contain) {
            return d2 < 0.5 ? this : backgroundSize;
        }
        double d3 = BackgroundSize.interpolate(this.width, backgroundSize.width, this.widthAsPercentage, backgroundSize.widthAsPercentage, d2);
        double d4 = BackgroundSize.interpolate(this.height, backgroundSize.height, this.heightAsPercentage, backgroundSize.heightAsPercentage, d2);
        if (d2 < 0.5) {
            bl2 = this.widthAsPercentage;
            bl = this.heightAsPercentage;
        } else {
            bl2 = backgroundSize.widthAsPercentage;
            bl = backgroundSize.heightAsPercentage;
        }
        if (this.isSame(d3, d4, bl2, bl)) {
            return this;
        }
        if (backgroundSize.isSame(d3, d4, bl2, bl)) {
            return backgroundSize;
        }
        return new BackgroundSize(d3, d4, bl2, bl, false, false);
    }

    private boolean isSame(double d2, double d3, boolean bl, boolean bl2) {
        return this.width == d2 && this.height == d3 && this.widthAsPercentage == bl && this.heightAsPercentage == bl2;
    }

    private static double interpolate(double d2, double d3, boolean bl, boolean bl2, double d4) {
        return bl == bl2 && d2 != -1.0 && d3 != -1.0 ? InterpolationUtils.interpolate(d2, d3, d4) : InterpolationUtils.interpolateDiscrete(d2, d3, d4);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BackgroundSize backgroundSize = (BackgroundSize)object;
        if (this.hash != backgroundSize.hash) {
            return false;
        }
        if (this.contain != backgroundSize.contain) {
            return false;
        }
        if (this.cover != backgroundSize.cover) {
            return false;
        }
        if (Double.compare(backgroundSize.height, this.height) != 0) {
            return false;
        }
        if (this.heightAsPercentage != backgroundSize.heightAsPercentage) {
            return false;
        }
        if (this.widthAsPercentage != backgroundSize.widthAsPercentage) {
            return false;
        }
        return Double.compare(backgroundSize.width, this.width) == 0;
    }

    public int hashCode() {
        return this.hash;
    }
}

