/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.SubPropertyConverter;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolatable;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

class BorderConverter
extends StyleConverter<ParsedValue[], Border>
implements SubPropertyConverter<Border> {
    private static final BorderConverter BORDER_IMAGE_CONVERTER = new BorderConverter();

    public static BorderConverter getInstance() {
        return BORDER_IMAGE_CONVERTER;
    }

    private BorderConverter() {
    }

    @Override
    public Border convert(Map<CssMetaData<? extends Styleable, ?>, Object> map) {
        BorderWidths borderWidths;
        Interpolatable<Insets> interpolatable;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3;
        Insets[] insetsArray;
        int n4;
        Interpolatable<CornerRadii>[] interpolatableArray;
        int n5;
        Interpolatable<Margins>[] interpolatableArray2;
        boolean bl;
        Paint[][] paintArray = (Paint[][])map.get(Border.BORDER_COLOR);
        BorderStrokeStyle[][] borderStrokeStyleArray = (BorderStrokeStyle[][])map.get(Border.BORDER_STYLE);
        Object[] objectArray = (Object[])map.get(Border.BORDER_IMAGE_SOURCE);
        boolean bl2 = paintArray != null && paintArray.length > 0 || borderStrokeStyleArray != null && borderStrokeStyleArray.length > 0;
        boolean bl3 = bl = objectArray != null && objectArray.length > 0;
        if (!bl2 && !bl) {
            return null;
        }
        BorderStroke[] borderStrokeArray = null;
        if (bl2) {
            int n6 = paintArray != null ? paintArray.length - 1 : -1;
            int n7 = borderStrokeStyleArray != null ? borderStrokeStyleArray.length - 1 : -1;
            int n8 = (n6 >= n7 ? n6 : n7) + 1;
            Object object4 = map.get(Border.BORDER_WIDTH);
            interpolatableArray2 = object4 == null ? new Margins[]{} : (Margins[])object4;
            n5 = interpolatableArray2.length - 1;
            object4 = map.get(Border.BORDER_RADIUS);
            interpolatableArray = object4 == null ? new CornerRadii[]{} : (CornerRadii[])object4;
            n4 = interpolatableArray.length - 1;
            object4 = map.get(Border.BORDER_INSETS);
            insetsArray = object4 == null ? new Insets[]{} : (Insets[])object4;
            n3 = insetsArray.length - 1;
            for (n2 = 0; n2 < n8; ++n2) {
                if (n7 < 0) {
                    object3 = new BorderStrokeStyle[4];
                    object3[2] = object3[3] = BorderStrokeStyle.SOLID;
                    object3[1] = object3[3];
                    object3[0] = object3[3];
                } else {
                    object3 = borderStrokeStyleArray[n2 <= n7 ? n2 : n7];
                }
                if (object3[0] == BorderStrokeStyle.NONE && object3[1] == BorderStrokeStyle.NONE && object3[2] == BorderStrokeStyle.NONE && object3[3] == BorderStrokeStyle.NONE) continue;
                if (n6 < 0) {
                    object2 = new Paint[4];
                    object2[2] = object2[3] = Color.BLACK;
                    object2[1] = object2[3];
                    object2[0] = object2[3];
                } else {
                    object2 = paintArray[n2 <= n6 ? n2 : n6];
                }
                if (borderStrokeArray == null) {
                    borderStrokeArray = new BorderStroke[n8];
                }
                Object object5 = interpolatableArray2.length == 0 ? null : (object = interpolatableArray2[n2 <= n5 ? n2 : n5]);
                Interpolatable<CornerRadii> interpolatable2 = interpolatableArray.length == 0 ? CornerRadii.EMPTY : (interpolatable = interpolatableArray[n2 <= n4 ? n2 : n4]);
                borderWidths = insetsArray.length == 0 ? null : insetsArray[n2 <= n3 ? n2 : n3];
                borderStrokeArray[n2] = new BorderStroke(object2[0], object2[1], object2[2], object2[3], object3[0], object3[1], object3[2], object3[3], (CornerRadii)interpolatable, object == null ? BorderStroke.DEFAULT_WIDTHS : new BorderWidths(((Margins)object).getTop(), ((Margins)object).getRight(), ((Margins)object).getBottom(), ((Margins)object).getLeft()), (Insets)((Object)borderWidths));
            }
        }
        BorderImage[] borderImageArray = null;
        if (bl) {
            borderImageArray = new BorderImage[objectArray.length];
            Object object6 = map.get(Border.BORDER_IMAGE_REPEAT);
            RepeatStruct[] repeatStructArray = object6 == null ? new RepeatStruct[]{} : (RepeatStruct[])object6;
            int n9 = repeatStructArray.length - 1;
            object6 = map.get(Border.BORDER_IMAGE_SLICE);
            interpolatableArray2 = object6 == null ? new BorderImageSlices[]{} : (BorderImageSlices[])object6;
            n5 = interpolatableArray2.length - 1;
            object6 = map.get(Border.BORDER_IMAGE_WIDTH);
            interpolatableArray = object6 == null ? new BorderWidths[]{} : (BorderWidths[])object6;
            n4 = interpolatableArray.length - 1;
            object6 = map.get(Border.BORDER_IMAGE_INSETS);
            insetsArray = object6 == null ? new Insets[]{} : (Insets[])object6;
            n3 = insetsArray.length - 1;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Image image;
                if (objectArray[n2] == null) continue;
                object3 = BorderRepeat.STRETCH;
                object2 = BorderRepeat.STRETCH;
                if (repeatStructArray.length > 0) {
                    object = repeatStructArray[n2 <= n9 ? n2 : n9];
                    object3 = this.convertToBorderRepeat(((RepeatStruct)object).repeatX);
                    object2 = this.convertToBorderRepeat(((RepeatStruct)object).repeatY);
                }
                Object object7 = interpolatableArray2.length > 0 ? interpolatableArray2[n2 <= n5 ? n2 : n5] : (object = BorderImageSlices.DEFAULT);
                Insets insets = insetsArray.length > 0 ? insetsArray[n2 <= n3 ? n2 : n3] : (interpolatable = Insets.EMPTY);
                borderWidths = interpolatableArray.length > 0 ? interpolatableArray[n2 <= n4 ? n2 : n4] : BorderWidths.DEFAULT;
                Object object8 = objectArray[n2];
                if (object8 instanceof String) {
                    String string = (String)object8;
                    image = StyleManager.getInstance().getCachedImage(string);
                } else {
                    object8 = objectArray[n2];
                    if (object8 instanceof Image) {
                        Image image2;
                        image = image2 = (Image)object8;
                    } else {
                        throw new IllegalArgumentException("Unexpected type: " + objectArray[n2].getClass().getName());
                    }
                }
                borderImageArray[n2] = new BorderImage(image, borderWidths, (Insets)interpolatable, ((BorderImageSlices)object).widths, ((BorderImageSlices)object).filled, (BorderRepeat)((Object)object3), (BorderRepeat)((Object)object2));
            }
        }
        return borderStrokeArray == null && borderImageArray == null ? null : new Border(borderStrokeArray, borderImageArray);
    }

    @Override
    public Map<CssMetaData<? extends Styleable, ?>, Object> convertBack(Border border) {
        Object object;
        List<BorderStroke> list = border.getStrokes();
        int n2 = list.size();
        Paint[][] paintArrayArray = new Paint[n2][];
        BorderStrokeStyle[][] borderStrokeStyleArrayArray = new BorderStrokeStyle[n2][];
        Margins[] marginsArray = new Margins[n2];
        CornerRadii[] cornerRadiiArray = new CornerRadii[n2];
        Insets[] insetsArray = new Insets[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BorderStroke borderStroke = list.get(i2);
            paintArrayArray[i2] = new Paint[4];
            paintArrayArray[i2][0] = borderStroke.getTopStroke();
            paintArrayArray[i2][1] = borderStroke.getRightStroke();
            paintArrayArray[i2][2] = borderStroke.getBottomStroke();
            paintArrayArray[i2][3] = borderStroke.getLeftStroke();
            borderStrokeStyleArrayArray[i2] = new BorderStrokeStyle[4];
            borderStrokeStyleArrayArray[i2][0] = borderStroke.getTopStyle();
            borderStrokeStyleArrayArray[i2][1] = borderStroke.getRightStyle();
            borderStrokeStyleArrayArray[i2][2] = borderStroke.getBottomStyle();
            borderStrokeStyleArrayArray[i2][3] = borderStroke.getLeftStyle();
            object = borderStroke.getWidths();
            marginsArray[i2] = new Margins(((BorderWidths)object).getTop(), ((BorderWidths)object).getRight(), ((BorderWidths)object).getBottom(), ((BorderWidths)object).getLeft(), false);
            cornerRadiiArray[i2] = borderStroke.getRadii();
            insetsArray[i2] = borderStroke.getInsets();
        }
        List<BorderImage> list2 = border.getImages();
        int n3 = list2.size();
        object = new Image[n3];
        RepeatStruct[] repeatStructArray = new RepeatStruct[n3];
        BorderImageSlices[] borderImageSlicesArray = new BorderImageSlices[n3];
        BorderWidths[] borderWidthsArray = new BorderWidths[n3];
        Insets[] insetsArray2 = new Insets[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            BorderImage borderImage = list2.get(i3);
            object[i3] = borderImage.getImage();
            repeatStructArray[i3] = new RepeatStruct(this.convertToBackgroundRepeat(borderImage.getRepeatX()), this.convertToBackgroundRepeat(borderImage.getRepeatY()));
            borderImageSlicesArray[i3] = new BorderImageSlices(borderImage.getSlices(), borderImage.isFilled());
            borderWidthsArray[i3] = borderImage.getWidths();
            insetsArray2[i3] = borderImage.getInsets();
        }
        return Map.of(Border.BORDER_COLOR, paintArrayArray, Border.BORDER_STYLE, borderStrokeStyleArrayArray, Border.BORDER_WIDTH, marginsArray, Border.BORDER_RADIUS, cornerRadiiArray, Border.BORDER_INSETS, insetsArray, Border.BORDER_IMAGE_SOURCE, object, Border.BORDER_IMAGE_REPEAT, repeatStructArray, Border.BORDER_IMAGE_SLICE, borderImageSlicesArray, Border.BORDER_IMAGE_WIDTH, borderWidthsArray, Border.BORDER_IMAGE_INSETS, insetsArray2);
    }

    private BackgroundRepeat convertToBackgroundRepeat(BorderRepeat borderRepeat) {
        return switch (borderRepeat) {
            default -> throw new MatchException(null, null);
            case BorderRepeat.REPEAT -> BackgroundRepeat.REPEAT;
            case BorderRepeat.ROUND -> BackgroundRepeat.ROUND;
            case BorderRepeat.SPACE -> BackgroundRepeat.SPACE;
            case BorderRepeat.STRETCH -> BackgroundRepeat.NO_REPEAT;
        };
    }

    private BorderRepeat convertToBorderRepeat(BackgroundRepeat backgroundRepeat) {
        return switch (backgroundRepeat) {
            default -> throw new MatchException(null, null);
            case BackgroundRepeat.REPEAT -> BorderRepeat.REPEAT;
            case BackgroundRepeat.ROUND -> BorderRepeat.ROUND;
            case BackgroundRepeat.SPACE -> BorderRepeat.SPACE;
            case BackgroundRepeat.NO_REPEAT -> BorderRepeat.STRETCH;
        };
    }

    public String toString() {
        return "BorderConverter";
    }
}

