/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.scene.layout.region.BorderImageSlices;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderWidths;

public final class BorderImage
implements Interpolatable<BorderImage> {
    private final Image image;
    private final BorderRepeat repeatX;
    private final BorderRepeat repeatY;
    private final BorderWidths widths;
    private final BorderWidths slices;
    private final boolean filled;
    private final Insets insets;
    final Insets innerEdge;
    final Insets outerEdge;
    private final int hash;

    public final Image getImage() {
        return this.image;
    }

    public final BorderRepeat getRepeatX() {
        return this.repeatX;
    }

    public final BorderRepeat getRepeatY() {
        return this.repeatY;
    }

    public final BorderWidths getWidths() {
        return this.widths;
    }

    public final BorderWidths getSlices() {
        return this.slices;
    }

    public final boolean isFilled() {
        return this.filled;
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public BorderImage(@NamedArg(value="image") Image image, @NamedArg(value="widths") BorderWidths borderWidths, @NamedArg(value="insets") Insets insets, @NamedArg(value="slices") BorderWidths borderWidths2, @NamedArg(value="filled") boolean bl, @NamedArg(value="repeatX") BorderRepeat borderRepeat, @NamedArg(value="repeatY") BorderRepeat borderRepeat2) {
        if (image == null) {
            throw new NullPointerException("Image cannot be null");
        }
        this.image = image;
        this.widths = borderWidths == null ? BorderWidths.DEFAULT : borderWidths;
        this.insets = insets == null ? Insets.EMPTY : insets;
        this.slices = borderWidths2 == null ? BorderImageSlices.DEFAULT.widths : borderWidths2;
        this.filled = bl;
        this.repeatX = borderRepeat == null ? BorderRepeat.STRETCH : borderRepeat;
        this.repeatY = borderRepeat2 == null ? this.repeatX : borderRepeat2;
        this.outerEdge = new Insets(Math.max(0.0, -this.insets.getTop()), Math.max(0.0, -this.insets.getRight()), Math.max(0.0, -this.insets.getBottom()), Math.max(0.0, -this.insets.getLeft()));
        this.innerEdge = new Insets(this.insets.getTop() + this.widths.getTop(), this.insets.getRight() + this.widths.getRight(), this.insets.getBottom() + this.widths.getBottom(), this.insets.getLeft() + this.widths.getLeft());
        int n2 = this.image.hashCode();
        n2 = 31 * n2 + this.widths.hashCode();
        n2 = 31 * n2 + this.slices.hashCode();
        n2 = 31 * n2 + this.repeatX.hashCode();
        n2 = 31 * n2 + this.repeatY.hashCode();
        this.hash = n2 = 31 * n2 + (this.filled ? 1 : 0);
    }

    @Override
    public BorderImage interpolate(BorderImage borderImage, double d2) {
        boolean bl;
        BorderRepeat borderRepeat;
        BorderRepeat borderRepeat2;
        Image image;
        Objects.requireNonNull(borderImage, "endValue cannot be null");
        if (d2 <= 0.0) {
            return this;
        }
        if (d2 >= 1.0) {
            return borderImage;
        }
        BorderWidths borderWidths = this.widths.interpolate(borderImage.widths, d2);
        BorderWidths borderWidths2 = this.slices.interpolate(borderImage.slices, d2);
        Insets insets = this.insets.interpolate(borderImage.insets, d2);
        if (d2 < 0.5) {
            image = this.image;
            borderRepeat2 = this.repeatX;
            borderRepeat = this.repeatY;
            bl = this.filled;
        } else {
            image = borderImage.image;
            borderRepeat2 = borderImage.repeatX;
            borderRepeat = borderImage.repeatY;
            bl = borderImage.filled;
        }
        if (this.isSame(image, borderWidths, borderWidths2, bl, borderRepeat2, borderRepeat)) {
            return this;
        }
        if (borderImage.isSame(image, borderWidths, borderWidths2, bl, borderRepeat2, borderRepeat)) {
            return borderImage;
        }
        return new BorderImage(borderImage.image, borderWidths, insets, borderWidths2, borderImage.filled, borderImage.repeatX, borderImage.repeatY);
    }

    private boolean isSame(Image image, BorderWidths borderWidths, BorderWidths borderWidths2, boolean bl, BorderRepeat borderRepeat, BorderRepeat borderRepeat2) {
        return this.image == image && this.widths == borderWidths && this.slices == borderWidths2 && this.filled == bl && this.repeatX == borderRepeat && this.repeatY == borderRepeat2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BorderImage borderImage = (BorderImage)object;
        if (this.hash != borderImage.hash) {
            return false;
        }
        if (this.filled != borderImage.filled) {
            return false;
        }
        if (!this.image.equals(borderImage.image)) {
            return false;
        }
        if (this.repeatX != borderImage.repeatX) {
            return false;
        }
        if (this.repeatY != borderImage.repeatY) {
            return false;
        }
        if (!this.slices.equals(borderImage.slices)) {
            return false;
        }
        return this.widths.equals(borderImage.widths);
    }

    public int hashCode() {
        return this.hash;
    }
}

