/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.util.InterpolationUtils;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;

public final class BorderWidths
implements Interpolatable<BorderWidths> {
    public static final double AUTO = -1.0;
    public static final BorderWidths DEFAULT = new BorderWidths(1.0, 1.0, 1.0, 1.0, false, false, false, false);
    public static final BorderWidths EMPTY = new BorderWidths(0.0, 0.0, 0.0, 0.0, false, false, false, false);
    public static final BorderWidths FULL = new BorderWidths(1.0, 1.0, 1.0, 1.0, true, true, true, true);
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private final boolean topAsPercentage;
    private final boolean rightAsPercentage;
    private final boolean bottomAsPercentage;
    private final boolean leftAsPercentage;
    private final int hash;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public final boolean isTopAsPercentage() {
        return this.topAsPercentage;
    }

    public final boolean isRightAsPercentage() {
        return this.rightAsPercentage;
    }

    public final boolean isBottomAsPercentage() {
        return this.bottomAsPercentage;
    }

    public final boolean isLeftAsPercentage() {
        return this.leftAsPercentage;
    }

    public BorderWidths(@NamedArg(value="width") double d2) {
        this(d2, d2, d2, d2, false, false, false, false);
    }

    public BorderWidths(@NamedArg(value="top") double d2, @NamedArg(value="right") double d3, @NamedArg(value="bottom") double d4, @NamedArg(value="left") double d5) {
        this(d2, d3, d4, d5, false, false, false, false);
    }

    public BorderWidths(@NamedArg(value="top") double d2, @NamedArg(value="right") double d3, @NamedArg(value="bottom") double d4, @NamedArg(value="left") double d5, @NamedArg(value="topAsPercentage") boolean bl, @NamedArg(value="rightAsPercentage") boolean bl2, @NamedArg(value="bottomAsPercentage") boolean bl3, @NamedArg(value="leftAsPercentage") boolean bl4) {
        if (d2 != -1.0 && d2 < 0.0 || d3 != -1.0 && d3 < 0.0 || d4 != -1.0 && d4 < 0.0 || d5 != -1.0 && d5 < 0.0) {
            throw new IllegalArgumentException("None of the widths can be < 0");
        }
        this.top = d2;
        this.right = d3;
        this.bottom = d4;
        this.left = d5;
        this.topAsPercentage = bl;
        this.rightAsPercentage = bl2;
        this.bottomAsPercentage = bl3;
        this.leftAsPercentage = bl4;
        long l2 = this.top != 0.0 ? Double.doubleToLongBits(this.top) : 0L;
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = this.right != 0.0 ? Double.doubleToLongBits(this.right) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.bottom != 0.0 ? Double.doubleToLongBits(this.bottom) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = this.left != 0.0 ? Double.doubleToLongBits(this.left) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 31 * n2 + (this.topAsPercentage ? 1 : 0);
        n2 = 31 * n2 + (this.rightAsPercentage ? 1 : 0);
        n2 = 31 * n2 + (this.bottomAsPercentage ? 1 : 0);
        this.hash = n2 = 31 * n2 + (this.leftAsPercentage ? 1 : 0);
    }

    @Override
    public BorderWidths interpolate(BorderWidths borderWidths, double d2) {
        boolean bl;
        double d3;
        boolean bl2;
        double d4;
        boolean bl3;
        double d5;
        boolean bl4;
        double d6;
        Objects.requireNonNull(borderWidths, "endValue cannot be null");
        if (d2 <= 0.0 || this.equals(borderWidths)) {
            return this;
        }
        if (d2 >= 1.0) {
            return borderWidths;
        }
        if (this.topAsPercentage == borderWidths.topAsPercentage) {
            d6 = BorderWidths.interpolate(this.top, borderWidths.top, d2);
            bl4 = this.topAsPercentage;
        } else if (d2 < 0.5) {
            d6 = this.top;
            bl4 = this.topAsPercentage;
        } else {
            d6 = borderWidths.top;
            bl4 = borderWidths.topAsPercentage;
        }
        if (this.rightAsPercentage == borderWidths.rightAsPercentage) {
            d5 = BorderWidths.interpolate(this.right, borderWidths.right, d2);
            bl3 = this.rightAsPercentage;
        } else if (d2 < 0.5) {
            d5 = this.right;
            bl3 = this.rightAsPercentage;
        } else {
            d5 = borderWidths.right;
            bl3 = borderWidths.rightAsPercentage;
        }
        if (this.bottomAsPercentage == borderWidths.bottomAsPercentage) {
            d4 = BorderWidths.interpolate(this.bottom, borderWidths.bottom, d2);
            bl2 = this.bottomAsPercentage;
        } else if (d2 < 0.5) {
            d4 = this.bottom;
            bl2 = this.bottomAsPercentage;
        } else {
            d4 = borderWidths.bottom;
            bl2 = borderWidths.bottomAsPercentage;
        }
        if (this.leftAsPercentage == borderWidths.leftAsPercentage) {
            d3 = BorderWidths.interpolate(this.left, borderWidths.left, d2);
            bl = this.leftAsPercentage;
        } else if (d2 < 0.5) {
            d3 = this.left;
            bl = this.leftAsPercentage;
        } else {
            d3 = borderWidths.left;
            bl = borderWidths.leftAsPercentage;
        }
        if (this.isSame(d6, d5, d4, d3, bl4, bl3, bl2, bl)) {
            return this;
        }
        if (borderWidths.isSame(d6, d5, d4, d3, bl4, bl3, bl2, bl)) {
            return borderWidths;
        }
        return new BorderWidths(d6, d5, d4, d3, bl4, bl3, bl2, bl);
    }

    private static double interpolate(double d2, double d3, double d4) {
        return d2 != -1.0 && d3 != -1.0 ? InterpolationUtils.interpolate(d2, d3, d4) : InterpolationUtils.interpolateDiscrete(d2, d3, d4);
    }

    private boolean isSame(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.top == d2 && this.right == d3 && this.bottom == d4 && this.left == d5 && this.topAsPercentage == bl && this.rightAsPercentage == bl2 && this.bottomAsPercentage == bl3 && this.leftAsPercentage == bl4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BorderWidths borderWidths = (BorderWidths)object;
        if (this.hash != borderWidths.hash) {
            return false;
        }
        if (Double.compare(borderWidths.bottom, this.bottom) != 0) {
            return false;
        }
        if (this.bottomAsPercentage != borderWidths.bottomAsPercentage) {
            return false;
        }
        if (Double.compare(borderWidths.left, this.left) != 0) {
            return false;
        }
        if (this.leftAsPercentage != borderWidths.leftAsPercentage) {
            return false;
        }
        if (Double.compare(borderWidths.right, this.right) != 0) {
            return false;
        }
        if (this.rightAsPercentage != borderWidths.rightAsPercentage) {
            return false;
        }
        if (Double.compare(borderWidths.top, this.top) != 0) {
            return false;
        }
        return this.topAsPercentage == borderWidths.topAsPercentage;
    }

    public int hashCode() {
        return this.hash;
    }
}

