/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class HBox
extends Pane {
    private boolean biasDirty = true;
    private double minBaselineComplement = Double.NaN;
    private double prefBaselineComplement = Double.NaN;
    private Orientation bias;
    private double[][] tempArray;
    private static final String MARGIN_CONSTRAINT = "hbox-margin";
    private static final String HGROW_CONSTRAINT = "hbox-hgrow";
    private static final Callback<Node, Insets> marginAccessor = node -> HBox.getMargin(node);
    private DoubleProperty spacing;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty fillHeight;
    private double baselineOffset = Double.NaN;

    public static void setHgrow(Node node, Priority priority) {
        HBox.setConstraint(node, HGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getHgrow(Node node) {
        return (Priority)((Object)HBox.getConstraint(node, HGROW_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        HBox.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)HBox.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        HBox.setHgrow(node, null);
        HBox.setMargin(node, null);
    }

    public HBox() {
    }

    public HBox(double d2) {
        this();
        this.setSpacing(d2);
    }

    public HBox(Node ... nodeArray) {
        this.getChildren().addAll((Node[])nodeArray);
    }

    public HBox(double d2, Node ... nodeArray) {
        this();
        this.setSpacing(d2);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SPACING;
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }
            };
        }
        return this.spacing;
    }

    public final void setSpacing(double d2) {
        this.spacingProperty().set(d2);
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.spacing.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public CssMetaData<HBox, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos pos = this.getAlignment();
        return pos == null ? Pos.TOP_LEFT : pos;
    }

    public final BooleanProperty fillHeightProperty() {
        if (this.fillHeight == null) {
            this.fillHeight = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    HBox.this.requestLayout();
                }

                @Override
                public CssMetaData<HBox, Boolean> getCssMetaData() {
                    return StyleableProperties.FILL_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return HBox.this;
                }

                @Override
                public String getName() {
                    return "fillHeight";
                }
            };
        }
        return this.fillHeight;
    }

    public final void setFillHeight(boolean bl) {
        this.fillHeightProperty().set(bl);
    }

    public final boolean isFillHeight() {
        return this.fillHeight == null ? true : this.fillHeight.get();
    }

    private boolean shouldFillHeight() {
        return this.isFillHeight() && this.getAlignmentInternal().getVpos() != VPos.BASELINE;
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            List list = this.getManagedChildren();
            for (Node node : list) {
                Orientation orientation = node.getContentBias();
                if (orientation == null) continue;
                this.bias = orientation;
                if (orientation != Orientation.HORIZONTAL) continue;
                break;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected double computeMinWidth(double d2) {
        Insets insets = this.getInsets();
        return this.snapSpaceX(insets.getLeft()) + this.computeContentWidth(this.getManagedChildren(), d2, true) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computeMinHeight(double d2) {
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        double d3 = 0.0;
        if (d2 != -1.0 && this.getContentBias() != null) {
            double[][] dArray = this.getAreaWidths(list, -1.0, false);
            this.adjustAreaWidths(list, dArray, d2, -1.0);
            d3 = this.computeMaxMinAreaHeight(list, marginAccessor, dArray[0], this.getAlignmentInternal().getVpos());
        } else {
            d3 = this.computeMaxMinAreaHeight(list, marginAccessor, this.getAlignmentInternal().getVpos());
        }
        return this.snapSpaceY(insets.getTop()) + d3 + this.snapSpaceY(insets.getBottom());
    }

    @Override
    protected double computePrefWidth(double d2) {
        Insets insets = this.getInsets();
        return this.snapSpaceX(insets.getLeft()) + this.computeContentWidth(this.getManagedChildren(), d2, false) + this.snapSpaceX(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d2) {
        Insets insets = this.getInsets();
        List<Node> list = this.getManagedChildren();
        double d3 = 0.0;
        if (d2 != -1.0 && this.getContentBias() != null) {
            double[][] dArray = this.getAreaWidths(list, -1.0, false);
            this.adjustAreaWidths(list, dArray, d2, -1.0);
            d3 = this.computeMaxPrefAreaHeight(list, marginAccessor, dArray[0], this.getAlignmentInternal().getVpos());
        } else {
            d3 = this.computeMaxPrefAreaHeight(list, marginAccessor, this.getAlignmentInternal().getVpos());
        }
        return this.snapSpaceY(insets.getTop()) + d3 + this.snapSpaceY(insets.getBottom());
    }

    private double[][] getAreaWidths(List<Node> list, double d2, boolean bl) {
        double[][] dArray = this.getTempArray(list.size());
        double d3 = d2 == -1.0 ? -1.0 : d2 - this.snapSpaceY(this.getInsets().getTop()) - this.snapSpaceY(this.getInsets().getBottom());
        boolean bl2 = this.shouldFillHeight();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = list.get(i2);
            Insets insets = HBox.getMargin(node);
            dArray[0][i2] = bl ? this.computeChildMinAreaWidth(node, this.getMinBaselineComplement(), insets, d3, bl2) : this.computeChildPrefAreaWidth(node, this.getPrefBaselineComplement(), insets, d3, bl2);
        }
        return dArray;
    }

    private double adjustAreaWidths(List<Node> list, double[][] dArray, double d2, double d3) {
        Insets insets = this.getInsets();
        double d4 = this.snapSpaceY(insets.getTop());
        double d5 = this.snapSpaceY(insets.getBottom());
        double d6 = HBox.sum(dArray[0], list.size()) + (double)(list.size() - 1) * this.snapSpaceX(this.getSpacing());
        double d7 = d2 - this.snapSpaceX(insets.getLeft()) - this.snapSpaceX(insets.getRight()) - d6;
        if (d7 != 0.0) {
            double d8 = this.shouldFillHeight() && d3 != -1.0 ? d3 - d4 - d5 : -1.0;
            double d9 = this.growOrShrinkAreaWidths(list, dArray, Priority.ALWAYS, d7, d8);
            d9 = this.growOrShrinkAreaWidths(list, dArray, Priority.SOMETIMES, d9, d8);
            d6 += d7 - d9;
        }
        return d6;
    }

    private double growOrShrinkAreaWidths(List<Node> list, double[][] dArray, Priority priority, double d2, double d3) {
        boolean bl = d2 < 0.0;
        int n2 = 0;
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        boolean bl2 = this.shouldFillHeight();
        if (bl) {
            n2 = list.size();
            var14_13 = list.size();
            for (var13_11 = 0; var13_11 < var14_13; ++var13_11) {
                var15_14 = list.get(var13_11);
                dArray3[var13_11] = this.computeChildMinAreaWidth(var15_14, this.getMinBaselineComplement(), HBox.getMargin(var15_14), d3, bl2);
            }
        } else {
            var14_13 = list.size();
            for (var13_11 = 0; var13_11 < var14_13; ++var13_11) {
                var15_14 = list.get(var13_11);
                if (HBox.getHgrow(var15_14) == priority) {
                    dArray3[var13_11] = this.computeChildMaxAreaWidth(var15_14, this.getMinBaselineComplement(), HBox.getMargin(var15_14), d3, bl2);
                    ++n2;
                    continue;
                }
                dArray3[var13_11] = -1.0;
            }
        }
        double d4 = this.isSnapToPixel() ? 1.0 / Region.getSnapScaleX(this) : 0.0;
        double d5 = d2;
        block2: while (Math.abs(d5) >= d4 && n2 > 0) {
            double d6 = this.snapPortionX(d5 / (double)n2);
            if (d6 == 0.0) {
                if (d4 == 0.0) break;
                d6 = d4 * Math.signum(d5);
            }
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (dArray3[i2] == -1.0) continue;
                double d7 = dArray3[i2] - dArray2[i2];
                double d8 = Math.abs(d7) <= Math.abs(d6) ? d7 : d6;
                int n4 = i2;
                dArray2[n4] = dArray2[n4] + d8;
                if (Math.abs(d5 -= d8) < d4) break block2;
                if (!(Math.abs(d8) < Math.abs(d6))) continue;
                dArray3[i2] = -1.0;
                --n2;
            }
        }
        return d5;
    }

    private double computeContentWidth(List<Node> list, double d2, boolean bl) {
        return HBox.sum(this.getAreaWidths(list, d2, bl)[0], list.size()) + (double)(list.size() - 1) * this.snapSpaceX(this.getSpacing());
    }

    private static double sum(double[] dArray, int n2) {
        int n3 = 0;
        double d2 = 0.0;
        while (n3 != n2) {
            d2 += dArray[n3++];
        }
        return d2;
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        this.minBaselineComplement = Double.NaN;
        this.prefBaselineComplement = Double.NaN;
        this.baselineOffset = Double.NaN;
        super.requestLayout();
    }

    private double getMinBaselineComplement() {
        if (Double.isNaN(this.minBaselineComplement)) {
            this.minBaselineComplement = this.getAlignmentInternal().getVpos() == VPos.BASELINE ? HBox.getMinBaselineComplement(this.getManagedChildren()) : -1.0;
        }
        return this.minBaselineComplement;
    }

    private double getPrefBaselineComplement() {
        if (Double.isNaN(this.prefBaselineComplement)) {
            this.prefBaselineComplement = this.getAlignmentInternal().getVpos() == VPos.BASELINE ? HBox.getPrefBaselineComplement(this.getManagedChildren()) : -1.0;
        }
        return this.prefBaselineComplement;
    }

    @Override
    public double getBaselineOffset() {
        List list = this.getManagedChildren();
        if (list.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(this.baselineOffset)) {
            VPos vPos = this.getAlignmentInternal().getVpos();
            if (vPos == VPos.BASELINE) {
                double d2 = 0.0;
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Node node = (Node)list.get(i2);
                    double d3 = node.getBaselineOffset();
                    if (d3 == Double.NEGATIVE_INFINITY) {
                        this.baselineOffset = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    Insets insets = HBox.getMargin(node);
                    double d4 = insets != null ? insets.getTop() : 0.0;
                    d2 = Math.max(d2, d4 + node.getLayoutBounds().getMinY() + d3);
                }
                this.baselineOffset = d2 + this.snappedTopInset();
            } else {
                this.baselineOffset = Double.NEGATIVE_INFINITY;
            }
        }
        return this.baselineOffset;
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        Pos pos = this.getAlignmentInternal();
        HPos hPos = pos.getHpos();
        VPos vPos = pos.getVpos();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.snapSpaceY(insets.getTop());
        double d5 = this.snapSpaceX(insets.getLeft());
        double d6 = this.snapSpaceY(insets.getBottom());
        double d7 = this.snapSpaceX(insets.getRight());
        double d8 = this.snapSpaceX(this.getSpacing());
        boolean bl = this.shouldFillHeight();
        double[][] dArray = this.getAreaWidths(list, d3, false);
        double d9 = this.adjustAreaWidths(list, dArray, d2, d3);
        double d10 = d3 - d4 - d6;
        double d11 = d5 + HBox.computeXOffset(d2 - d5 - d7, d9, pos.getHpos());
        double d12 = d4;
        double d13 = -1.0;
        if (vPos == VPos.BASELINE) {
            double d14 = this.getMinBaselineComplement();
            d13 = this.getAreaBaselineOffset(list, marginAccessor, (Integer n2) -> dArray[0][n2], d10, bl, d14);
        }
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Node node = list.get(i2);
            Insets insets2 = HBox.getMargin(node);
            this.layoutInArea(node, d11, d12, dArray[0][i2], d10, d13, insets2, true, bl, hPos, vPos);
            d11 += dArray[0][i2] + d8;
        }
    }

    private double[][] getTempArray(int n2) {
        if (this.tempArray == null) {
            this.tempArray = new double[2][n2];
        } else if (this.tempArray[0].length < n2) {
            this.tempArray = new double[2][Math.max(this.tempArray.length * 3, n2)];
        }
        return this.tempArray;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return HBox.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<HBox, Pos> ALIGNMENT = new CssMetaData<HBox, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(HBox hBox) {
                return hBox.alignment == null || !hBox.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(HBox hBox) {
                return (StyleableProperty)((Object)hBox.alignmentProperty());
            }
        };
        private static final CssMetaData<HBox, Boolean> FILL_HEIGHT = new CssMetaData<HBox, Boolean>("-fx-fill-height", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(HBox hBox) {
                return hBox.fillHeight == null || !hBox.fillHeight.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(HBox hBox) {
                return (StyleableProperty)((Object)hBox.fillHeightProperty());
            }
        };
        private static final CssMetaData<HBox, Number> SPACING = new CssMetaData<HBox, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(HBox hBox) {
                return hBox.spacing == null || !hBox.spacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(HBox hBox) {
                return (StyleableProperty)((Object)hBox.spacingProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Pane.getClassCssMetaData());
            arrayList.add(FILL_HEIGHT);
            arrayList.add(ALIGNMENT);
            arrayList.add(SPACING);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

